/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import java.security.cert.X509Certificate;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.principal.AbstractX509PrincipalResolver;
import org.apereo.cas.authentication.principal.resolvers.PrincipalResolutionContext;

public class X509SerialNumberPrincipalResolver
extends AbstractX509PrincipalResolver {
    private static final int DEFAULT_RADIX = 10;
    private int radix = 10;
    private boolean zeroPadding;

    public X509SerialNumberPrincipalResolver(PrincipalResolutionContext context) {
        super(context);
    }

    @Override
    protected String resolvePrincipalInternal(X509Certificate certificate) {
        String principal = certificate.getSerialNumber().toString(this.radix);
        if (this.zeroPadding && principal.length() % 2 != 0) {
            return "0" + principal;
        }
        return principal;
    }

    @Override
    @Generated
    public String toString() {
        return "X509SerialNumberPrincipalResolver(super=" + super.toString() + ", radix=" + this.radix + ", zeroPadding=" + this.zeroPadding + ")";
    }

    @Generated
    public void setRadix(int radix) {
        this.radix = radix;
    }

    @Generated
    public void setZeroPadding(boolean zeroPadding) {
        this.zeroPadding = zeroPadding;
    }
}

