/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.generic.AcceptAuthenticationProperties;
import org.apereo.cas.util.AsciiArtUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Authentication, module="accept")
@AutoConfiguration
public class AcceptUsersAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptUsersAuthenticationEventExecutionPlanConfiguration.class);

    @ConditionalOnMissingBean(name={"acceptUsersAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer acceptUsersAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="acceptUsersAuthenticationHandler") AuthenticationHandler acceptUsersAuthenticationHandler, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, CasConfigurationProperties casProperties) {
        return plan -> {
            AcceptAuthenticationProperties accept = casProperties.getAuthn().getAccept();
            if (accept.isEnabled() && StringUtils.isNotBlank((CharSequence)accept.getUsers())) {
                plan.registerAuthenticationHandlerWithPrincipalResolver(acceptUsersAuthenticationHandler, defaultPrincipalResolver);
            }
        };
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public InitializingBean acceptUsersAuthenticationInitializingBean(CasConfigurationProperties casProperties) {
        return () -> {
            AcceptAuthenticationProperties accept = casProperties.getAuthn().getAccept();
            if (accept.isEnabled() && StringUtils.isNotBlank((CharSequence)accept.getUsers())) {
                String header = "\nCAS is configured to accept a static list of credentials for authentication. While this is generally useful for demo purposes, it is STRONGLY recommended that you DISABLE this authentication method by setting 'cas.authn.accept.enabled=false' and switch to a mode that is more suitable for production.";
                AsciiArtUtils.printAsciiArtWarning((Logger)LOGGER, (String)"\nCAS is configured to accept a static list of credentials for authentication. While this is generally useful for demo purposes, it is STRONGLY recommended that you DISABLE this authentication method by setting 'cas.authn.accept.enabled=false' and switch to a mode that is more suitable for production.");
            }
        };
    }
}

