/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public class DefaultOAuth20AuthorizationModelAndViewBuilder
implements OAuth20AuthorizationModelAndViewBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20AuthorizationModelAndViewBuilder.class);

    public ModelAndView build(OAuthRegisteredService registeredService, OAuth20ResponseModeTypes responseMode, String url, Map<String, String> parameters) throws Exception {
        String redirectUrl = this.prepareRedirectUrl(registeredService, url, parameters);
        if (OAuth20Utils.isResponseModeTypeFormPost(registeredService, responseMode)) {
            LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
            model.put("originalUrl", redirectUrl);
            model.put("parameters", parameters);
            ModelAndView mv = new ModelAndView("casPostResponseView", model);
            LOGGER.debug("Redirecting to [{}] with model [{}]", (Object)mv.getViewName(), (Object)mv.getModel());
            return mv;
        }
        if (OAuth20Utils.isResponseModeTypeFragment(registeredService, responseMode)) {
            URIBuilder urlBuilder = new URIBuilder(redirectUrl);
            List currentParams = urlBuilder.getQueryParams();
            urlBuilder.removeQuery();
            currentParams.removeIf(p -> parameters.containsKey(p.getName()));
            String fragment = parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
            urlBuilder.setFragment(fragment);
            urlBuilder.setParameters(currentParams);
            String resultUrl = urlBuilder.build().toURL().toExternalForm();
            LOGGER.debug("Redirecting to [{}]", (Object)resultUrl);
            RedirectView mv = new RedirectView(resultUrl);
            return new ModelAndView((View)mv);
        }
        RedirectView mv = new RedirectView(redirectUrl);
        return new ModelAndView((View)mv, parameters);
    }

    protected String prepareRedirectUrl(OAuthRegisteredService registeredService, String redirectUrl, Map<String, String> parameters) throws Exception {
        return redirectUrl;
    }
}

