/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.generator;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;

@FunctionalInterface
public interface SamlIdPMetadataGenerator {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public SamlIdPMetadataDocument generate(Optional<SamlRegisteredService> var1) throws Exception;

    public static String cleanCertificate(String cert) {
        String result = StringUtils.remove((String)cert, (String)BEGIN_CERTIFICATE);
        result = StringUtils.remove((String)result, (String)END_CERTIFICATE).trim();
        return result;
    }

    public static String getAppliesToFor(Optional<SamlRegisteredService> result) {
        if (result.isPresent()) {
            SamlRegisteredService registeredService = result.get();
            return registeredService.getName() + "-" + registeredService.getId();
        }
        return "CAS";
    }
}

