/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;

public abstract class AjaxLink<T>
extends AbstractLink
implements IAjaxLink,
IGenericComponent<T, AjaxLink<T>> {
    private static final long serialVersionUID = 1L;

    public AjaxLink(String id) {
        this(id, (IModel<T>)null);
    }

    public AjaxLink(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxEventBehavior("click"));
    }

    protected AjaxEventBehavior newAjaxEventBehavior(String event) {
        return new AjaxEventBehavior(event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                AjaxLink.this.onClick(target);
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                attributes.setPreventDefault(true);
                super.updateAjaxAttributes(attributes);
                AjaxLink.this.updateAjaxAttributes(attributes);
            }

            @Override
            public boolean getStatelessHint(Component component) {
                return AjaxLink.this.getStatelessHint();
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnabledInHierarchy()) {
            String tagName = tag.getName();
            if (tagName.equalsIgnoreCase("a") || tagName.equalsIgnoreCase("link") || tagName.equalsIgnoreCase("area")) {
                tag.put("href", "#");
            } else if (tagName.equalsIgnoreCase("button")) {
                tag.put("type", "button");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public abstract void onClick(AjaxRequestTarget var1);

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

