/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.strava;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.strava.StravaClub;
import org.pac4j.oauth.profile.strava.StravaGear;
import org.pac4j.oauth.profile.strava.StravaProfile;

public class StravaProfileDefinition
extends OAuthProfileDefinition {
    public static final String ID = "id";
    public static final String RESOURCE_STATE = "resource_state";
    public static final String FIRST_NAME = "firstname";
    public static final String LAST_NAME = "lastname";
    public static final String PROFILE_MEDIUM = "profile_medium";
    public static final String PROFILE = "profile";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String COUNTRY = "country";
    public static final String SEX = "sex";
    public static final String PREMIUM = "premium";
    public static final String CREATED_AT = "created_at";
    public static final String UPDATED_AT = "updated_at";
    public static final String BADGE_TYPE_ID = "badge_type_id";
    public static final String FOLLOWER_COUNT = "follower_count";
    public static final String FRIEND_COUNT = "friend_count";
    public static final String DATE_PREFERENCE = "date_preference";
    public static final String MEASUREMENT_PREFERENCE = "measurement_preference";
    public static final String CLUBS = "clubs";
    public static final String BIKES = "bikes";
    public static final String SHOES = "shoes";

    public StravaProfileDefinition() {
        super(x -> new StravaProfile());
        Arrays.stream(new String[]{FIRST_NAME, LAST_NAME, PROFILE_MEDIUM, CITY, STATE, COUNTRY, DATE_PREFERENCE, MEASUREMENT_PREFERENCE}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(ID, (AttributeConverter)Converters.LONG);
        this.primary(RESOURCE_STATE, (AttributeConverter)Converters.INTEGER);
        this.primary(BADGE_TYPE_ID, (AttributeConverter)Converters.INTEGER);
        this.primary(FOLLOWER_COUNT, (AttributeConverter)Converters.INTEGER);
        this.primary(FRIEND_COUNT, (AttributeConverter)Converters.INTEGER);
        this.primary(PREMIUM, (AttributeConverter)Converters.BOOLEAN);
        this.primary(SEX, (AttributeConverter)Converters.GENDER);
        this.primary(CREATED_AT, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(UPDATED_AT, (AttributeConverter)Converters.DATE_TZ_RFC822);
        this.primary(CLUBS, new JsonConverter(List.class, (TypeReference<? extends Object>)new TypeReference<List<StravaClub>>(){}));
        JsonConverter multiGearConverter = new JsonConverter(List.class, (TypeReference<? extends Object>)new TypeReference<List<StravaGear>>(){});
        this.primary(BIKES, multiGearConverter);
        this.primary(SHOES, multiGearConverter);
        this.primary(PROFILE, (AttributeConverter)Converters.URL);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://www.strava.com/api/v3/athlete";
    }

    @Override
    public StravaProfile extractUserProfile(String body) {
        StravaProfile profile = (StravaProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(json, ID)));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

