/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.adaptors.u2f.storage.BaseResourceU2FDeviceRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FRestfulMultifactorAuthenticationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class U2FRestResourceDeviceRepository
extends BaseResourceU2FDeviceRepository {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();

    public U2FRestResourceDeviceRepository(LoadingCache<String, String> requestStorage, CasConfigurationProperties casProperties, CipherExecutor<Serializable, String> cipherExecutor) {
        super(requestStorage, casProperties, cipherExecutor);
    }

    @Override
    public Map<String, List<U2FDeviceRegistration>> readDevicesFromResource() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            HttpResponse response;
            block8: {
                HashMap hashMap;
                InputStream content;
                block9: {
                    response = null;
                    U2FRestfulMultifactorAuthenticationProperties rest = this.casProperties.getAuthn().getMfa().getU2f().getRest();
                    HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.GET).url(rest.getUrl()).build();
                    response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                    if (Objects.requireNonNull(response).getStatusLine().getStatusCode() != HttpStatus.OK.value()) break block8;
                    content = response.getEntity().getContent();
                    hashMap = (HashMap)MAPPER.readValue(content, (TypeReference)new TypeReference<HashMap<String, List<U2FDeviceRegistration>>>(){});
                    if (content == null) break block9;
                    content.close();
                }
                HttpUtils.close((HttpResponse)response);
                return hashMap;
                {
                    catch (Throwable throwable) {
                        try {
                            if (content != null) {
                                try {
                                    content.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            HttpUtils.close(response);
                            throw throwable3;
                        }
                    }
                }
            }
            HttpUtils.close((HttpResponse)response);
            return new HashMap(0);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDevicesBackToResource(List<U2FDeviceRegistration> list) {
        HttpResponse response = null;
        try (StringWriter writer = new StringWriter();){
            HashMap<String, List<U2FDeviceRegistration>> newDevices = new HashMap<String, List<U2FDeviceRegistration>>();
            newDevices.put("devices", list);
            MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValue((Writer)writer, newDevices);
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
            U2FRestfulMultifactorAuthenticationProperties rest = this.casProperties.getAuthn().getMfa().getU2f().getRest();
            headers.putAll(rest.getHeaders());
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.POST).url(rest.getUrl()).headers(headers).entity(writer.toString()).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRegisteredDevice(U2FDeviceRegistration registration) {
        HttpResponse response = null;
        try {
            U2FRestfulMultifactorAuthenticationProperties rest = this.casProperties.getAuthn().getMfa().getU2f().getRest();
            String url = StringUtils.appendIfMissing((String)rest.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + registration.getId();
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.DELETE).url(url).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        HttpResponse response = null;
        try {
            U2FRestfulMultifactorAuthenticationProperties rest = this.casProperties.getAuthn().getMfa().getU2f().getRest();
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.DELETE).url(rest.getUrl()).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
        }
        catch (Throwable throwable) {
            HttpUtils.close(response);
            throw throwable;
        }
        HttpUtils.close((HttpResponse)response);
    }
}

