/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.OIDCJWKS;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.jose4j.jwk.EcJwkGenerator;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jwk.RsaJwkGenerator;
import org.jose4j.keys.EllipticCurves;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCJWKSDataBinderImpl
implements OIDCJWKSDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCJWKSDataBinder.class);
    protected final EntityFactory entityFactory;

    public OIDCJWKSDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public OIDCJWKSTO getOIDCJWKSTO(OIDCJWKS jwks) {
        return new OIDCJWKSTO.Builder().key(jwks.getKey()).json(jwks.getJson()).build();
    }

    protected PublicJsonWebKey generate(String jwksKeyId, String jwksType, int jwksKeySize, String use, OIDCJWKSDataBinder.JsonWebKeyLifecycleState state) throws JoseException {
        RsaJsonWebKey jwk;
        block4 : switch (jwksType.trim().toLowerCase(Locale.ENGLISH)) {
            case "ec": {
                switch (jwksKeySize) {
                    case 384: {
                        jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P384);
                        jwk.setAlgorithm("ES384");
                        break block4;
                    }
                    case 512: {
                        jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P521);
                        jwk.setAlgorithm("ES512");
                        break block4;
                    }
                }
                jwk = EcJwkGenerator.generateJwk((ECParameterSpec)EllipticCurves.P256);
                jwk.setAlgorithm("ES512");
                break;
            }
            default: {
                jwk = RsaJwkGenerator.generateJwk((int)jwksKeySize);
            }
        }
        jwk.setKeyId(jwksKeyId.concat("-").concat(SecureRandomUtils.generateRandomLetters((int)8)));
        jwk.setUse(use);
        jwk.setOtherParameter("state", (Object)state.getState());
        return jwk;
    }

    public OIDCJWKS create(String jwksKeyId, String jwksType, int jwksKeySize) {
        ArrayList<PublicJsonWebKey> keys = new ArrayList<PublicJsonWebKey>();
        try {
            keys.add(this.generate(jwksKeyId, jwksType, jwksKeySize, "sig", OIDCJWKSDataBinder.JsonWebKeyLifecycleState.CURRENT));
            keys.add(this.generate(jwksKeyId, jwksType, jwksKeySize, "enc", OIDCJWKSDataBinder.JsonWebKeyLifecycleState.CURRENT));
            keys.add(this.generate(jwksKeyId, jwksType, jwksKeySize, "sig", OIDCJWKSDataBinder.JsonWebKeyLifecycleState.FUTURE));
            keys.add(this.generate(jwksKeyId, jwksType, jwksKeySize, "enc", OIDCJWKSDataBinder.JsonWebKeyLifecycleState.FUTURE));
        }
        catch (JoseException e) {
            LOG.error("Could not create OIDC JWKS", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        OIDCJWKS oidcJWKS = (OIDCJWKS)this.entityFactory.newEntity(OIDCJWKS.class);
        oidcJWKS.setJson(new JsonWebKeySet(keys).toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE));
        return oidcJWKS;
    }
}

