/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Models;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class BootstrapExternalLink
extends ExternalLink
implements IBootstrapButton<BootstrapExternalLink> {
    private static final long serialVersionUID = 1L;
    private Icon icon;
    private Component label;
    private Component splitter;
    private ButtonBehavior buttonBehavior;
    private final IModel<String> target = Model.of((Serializable)((Object)""));
    private final Buttons.Type type;

    public BootstrapExternalLink(String id, IModel<String> href) {
        this(id, href, Buttons.Type.Link);
    }

    public BootstrapExternalLink(String id, IModel<String> model, Buttons.Type type) {
        super(id, model);
        this.type = type;
        this.add(new Behavior[]{this.getButtonBehavior()});
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.getIcon(), this.getSplitter(), this.getLinkLabel()});
    }

    private ButtonBehavior getButtonBehavior() {
        if (this.buttonBehavior == null) {
            this.buttonBehavior = new ButtonBehavior(this.type, Buttons.Size.Medium);
        }
        return this.buttonBehavior;
    }

    private Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.newIcon("icon");
        }
        return this.icon;
    }

    private Component getSplitter() {
        if (this.splitter == null) {
            this.splitter = this.newSplitter("splitter");
        }
        return this.splitter;
    }

    private Component getLinkLabel() {
        if (this.label == null) {
            this.label = this.newLabel("label");
        }
        return this.label;
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId) {
        return new Label(markupId, (IModel)new Model((Serializable)((Object)""))).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!Models.isNullOrEmpty(this.target)) {
            tag.put("target", (CharSequence)this.target.getObject());
        }
        super.onComponentTag(tag);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.getSplitter().setVisible(this.getIcon().hasIconType() && StringUtils.isNotEmpty((CharSequence)this.getLinkLabel().getDefaultModelObjectAsString()));
    }

    public BootstrapExternalLink setLabel(IModel<?> label) {
        this.getLinkLabel().setDefaultModel(label);
        return this;
    }

    public BootstrapExternalLink setIconType(IconType iconType) {
        this.getIcon().setType(iconType);
        return this;
    }

    @Override
    public BootstrapExternalLink setSize(Buttons.Size size) {
        this.getButtonBehavior().setSize(size);
        return this;
    }

    @Override
    public BootstrapExternalLink setType(Buttons.Type type) {
        this.getButtonBehavior().setType(type);
        return this;
    }

    public BootstrapExternalLink setBlock(boolean block) {
        this.getButtonBehavior().setBlock(block);
        return this;
    }

    public BootstrapExternalLink setTarget(Target target) {
        if (target == null || target == Target.none) {
            this.target.setObject((Object)"");
        } else {
            this.target.setObject((Object)("_" + target.name()));
        }
        return this;
    }

    protected void detachModel() {
        super.detachModel();
        this.target.detach();
    }

    public static enum Target {
        blank,
        self,
        parent,
        top,
        none;

    }
}

