/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.conf.CacheMarshaller;
import org.apache.openjpa.conf.CacheMarshallerImpl;
import org.apache.openjpa.conf.NoOpCacheMarshaller;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class CacheMarshallersValue
extends PluginListValue {
    private static final String KEY = "CacheMarshallers";
    private static final CacheMarshaller NO_OP_CACHE_MARSHALLER = new NoOpCacheMarshaller();
    private static final Localizer _loc = Localizer.forPackage(CacheMarshallersValue.class);
    private Configuration _conf;
    private Map<String, CacheMarshaller> _marshallers;
    private boolean _initialized;

    public CacheMarshallersValue(Configuration conf) {
        super(KEY);
        this._conf = conf;
        this.setAlias("default", CacheMarshallerImpl.class.getName());
        this.setAlias("none", null);
        this.setDefault("none");
        this.setString("none");
        this.setScope(((Object)((Object)this)).getClass());
    }

    public Object instantiate(Class<?> elemType, Configuration conf, boolean fatal) {
        CacheMarshaller[] ms = (CacheMarshaller[])super.instantiate(elemType, conf, fatal);
        if (ms != null) {
            this._marshallers = new HashMap<String, CacheMarshaller>();
            for (CacheMarshaller m : ms) {
                String mid = m.getId();
                if (mid == null) continue;
                this._marshallers.put(mid, m);
            }
        } else {
            this._marshallers = null;
        }
        return ms;
    }

    public CacheMarshaller getMarshallerById(String id) {
        this.initialize();
        CacheMarshaller cm = this._marshallers.get(id);
        if (cm == null) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)_loc.get("cache-marshaller-not-found", (Object)id));
            }
            return NO_OP_CACHE_MARSHALLER;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)_loc.get("cache-marshaller-found", (Object)id, (Object)cm.getClass().getName()));
        }
        return cm;
    }

    private Log getLog() {
        return this._conf.getConfigurationLog();
    }

    public static CacheMarshaller getMarshallerById(Configuration c, String id) {
        CacheMarshallersValue v = ((OpenJPAConfigurationImpl)c).cacheMarshallerPlugins;
        return v.getMarshallerById(id);
    }

    public Map<String, CacheMarshaller> getInstancesAsMap() {
        return this._marshallers;
    }

    protected synchronized void initialize() {
        if (!this._initialized) {
            this.instantiate(CacheMarshaller.class, this._conf);
            this._initialized = true;
        }
    }
}

