/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Base64;
import org.identityconnectors.framework.common.objects.SyncToken;

class SyncTokenSerializer
extends JsonSerializer<SyncToken> {
    SyncTokenSerializer() {
    }

    public void serialize(SyncToken source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        if (source.getValue() == null) {
            jgen.writeNullField("value");
        } else if (source.getValue() instanceof Boolean) {
            jgen.writeStringField("type", Boolean.class.getSimpleName());
            jgen.writeBooleanField("value", ((Boolean)source.getValue()).booleanValue());
        } else if (source.getValue() instanceof Double) {
            jgen.writeStringField("type", Double.class.getSimpleName());
            jgen.writeNumberField("value", ((Double)source.getValue()).doubleValue());
        } else if (source.getValue() instanceof Long) {
            jgen.writeStringField("type", Long.class.getSimpleName());
            jgen.writeNumberField("value", ((Long)source.getValue()).longValue());
        } else if (source.getValue() instanceof Integer) {
            jgen.writeStringField("type", Integer.class.getSimpleName());
            jgen.writeNumberField("value", ((Integer)source.getValue()).intValue());
        } else if (source.getValue() instanceof byte[]) {
            jgen.writeStringField("value", Base64.getEncoder().encodeToString((byte[])source.getValue()));
        } else {
            jgen.writeStringField("type", String.class.getSimpleName());
            jgen.writeStringField("value", source.getValue().toString());
        }
        jgen.writeEndObject();
    }
}

