/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtBuilder.class);
    private final CipherExecutor<Serializable, String> defaultTokenCipherExecutor;
    private final ServicesManager servicesManager;
    private final RegisteredServiceCipherExecutor registeredServiceCipherExecutor;
    private final CasConfigurationProperties casProperties;

    public static JWTClaimsSet parse(String jwt) {
        try {
            return JWTParser.parse((String)jwt).getJWTClaimsSet();
        }
        catch (Exception e) {
            LOGGER.trace("Unable to parse [{}] JWT; trying JWT claim set...", (Object)jwt);
            try {
                return JWTClaimsSet.parse((String)jwt);
            }
            catch (Exception ex) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)ex);
                throw new IllegalArgumentException("Unable to parse JWT");
            }
        }
    }

    public static String buildPlain(JWTClaimsSet claimsSet, Optional<RegisteredService> registeredService) {
        PlainHeader.Builder header = new PlainHeader.Builder().type(JOSEObjectType.JWT);
        registeredService.ifPresent(svc -> header.customParam(RegisteredServiceCipherExecutor.CUSTOM_HEADER_REGISTERED_SERVICE_ID, (Object)svc.getId()));
        return new PlainJWT(header.build(), claimsSet).serialize();
    }

    public JWTClaimsSet unpack(Optional<RegisteredService> service, String jwtJson) {
        return (JWTClaimsSet)FunctionUtils.doUnchecked(() -> {
            service.ifPresent(svc -> {
                LOGGER.trace("Located service [{}] in service registry", svc);
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)svc);
            });
            JWT jwt = JWTParser.parse((String)jwtJson);
            if (jwt instanceof SignedJWT) {
                if (service.isPresent()) {
                    RegisteredService registeredService = (RegisteredService)service.get();
                    LOGGER.trace("Locating service signing and encryption keys for [{}]", (Object)registeredService.getServiceId());
                    if (this.registeredServiceCipherExecutor.supports(registeredService)) {
                        LOGGER.trace("Decoding JWT based on keys provided by service [{}]", (Object)registeredService.getServiceId());
                        return JwtBuilder.parse(this.registeredServiceCipherExecutor.decode(jwtJson, Optional.of(registeredService)));
                    }
                }
                return (JWTClaimsSet)FunctionUtils.doIf((boolean)this.defaultTokenCipherExecutor.isEnabled(), () -> {
                    LOGGER.trace("Decoding JWT based on default global keys");
                    return JwtBuilder.parse((String)this.defaultTokenCipherExecutor.decode((Object)jwtJson));
                }, () -> {
                    throw new IllegalArgumentException("Unable to validate JWT signature");
                }).get();
            }
            return JwtBuilder.parse(jwtJson);
        });
    }

    public String build(JwtRequest payload) {
        String serviceAudience = payload.getServiceAudience();
        Objects.requireNonNull(payload.getIssuer(), "Issuer cannot be undefined");
        JWTClaimsSet.Builder claims = new JWTClaimsSet.Builder().audience(serviceAudience).issuer(payload.getIssuer()).jwtID(payload.getJwtId()).issueTime(payload.getIssueDate()).subject(payload.getSubject());
        payload.getAttributes().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE)).forEach(entry -> {
            Object claimValue;
            List value = (List)entry.getValue();
            Object object = claimValue = value.size() == 1 ? CollectionUtils.firstElement((Object)value).get() : value;
            if (claimValue instanceof ZonedDateTime) {
                claimValue = claimValue.toString();
            }
            claims.claim((String)entry.getKey(), claimValue);
        });
        claims.expirationTime(payload.getValidUntilDate());
        JWTClaimsSet claimsSet = claims.build();
        String jwtJson = claimsSet.toString();
        LOGGER.debug("Generated JWT [{}]", (Object)jwtJson);
        LOGGER.trace("Locating service [{}] in service registry", (Object)serviceAudience);
        RegisteredService registeredService = payload.getRegisteredService().isEmpty() ? this.locateRegisteredService(serviceAudience) : payload.getRegisteredService().get();
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
        LOGGER.trace("Locating service specific signing and encryption keys for [{}] in service registry", (Object)serviceAudience);
        if (this.registeredServiceCipherExecutor.supports(registeredService)) {
            LOGGER.trace("Encoding JWT based on keys provided by service [{}]", (Object)registeredService.getServiceId());
            return this.registeredServiceCipherExecutor.encode(jwtJson, Optional.of(registeredService));
        }
        if (this.defaultTokenCipherExecutor.isEnabled()) {
            LOGGER.trace("Encoding JWT based on default global keys for [{}]", (Object)serviceAudience);
            return (String)this.defaultTokenCipherExecutor.encode((Object)jwtJson);
        }
        String token = JwtBuilder.buildPlain(claimsSet, Optional.of(registeredService));
        LOGGER.trace("Generating plain JWT as the ticket: [{}]", (Object)token);
        return token;
    }

    protected RegisteredService locateRegisteredService(String serviceAudience) {
        return this.servicesManager.findServiceBy((Service)new WebApplicationServiceFactory().createService(serviceAudience));
    }

    @Generated
    public JwtBuilder(CipherExecutor<Serializable, String> defaultTokenCipherExecutor, ServicesManager servicesManager, RegisteredServiceCipherExecutor registeredServiceCipherExecutor, CasConfigurationProperties casProperties) {
        this.defaultTokenCipherExecutor = defaultTokenCipherExecutor;
        this.servicesManager = servicesManager;
        this.registeredServiceCipherExecutor = registeredServiceCipherExecutor;
        this.casProperties = casProperties;
    }

    @Generated
    public CipherExecutor<Serializable, String> getDefaultTokenCipherExecutor() {
        return this.defaultTokenCipherExecutor;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public RegisteredServiceCipherExecutor getRegisteredServiceCipherExecutor() {
        return this.registeredServiceCipherExecutor;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    public static class JwtRequest {
        private final String jwtId;
        private final String serviceAudience;
        private final Date issueDate;
        private final String subject;
        private final Date validUntilDate;
        private final String issuer;
        private final Map<String, List<Object>> attributes;
        private Optional<RegisteredService> registeredService;

        @Generated
        private static Map<String, List<Object>> $default$attributes() {
            return new LinkedHashMap<String, List<Object>>();
        }

        @Generated
        private static Optional<RegisteredService> $default$registeredService() {
            return Optional.empty();
        }

        @Generated
        protected JwtRequest(JwtRequestBuilder<?, ?> b) {
            this.jwtId = b.jwtId;
            this.serviceAudience = b.serviceAudience;
            this.issueDate = b.issueDate;
            this.subject = b.subject;
            this.validUntilDate = b.validUntilDate;
            this.issuer = b.issuer;
            this.attributes = b.attributes$set ? b.attributes$value : JwtRequest.$default$attributes();
            this.registeredService = b.registeredService$set ? b.registeredService$value : JwtRequest.$default$registeredService();
        }

        @Generated
        public static JwtRequestBuilder<?, ?> builder() {
            return new JwtRequestBuilderImpl();
        }

        @Generated
        public String getJwtId() {
            return this.jwtId;
        }

        @Generated
        public String getServiceAudience() {
            return this.serviceAudience;
        }

        @Generated
        public Date getIssueDate() {
            return this.issueDate;
        }

        @Generated
        public String getSubject() {
            return this.subject;
        }

        @Generated
        public Date getValidUntilDate() {
            return this.validUntilDate;
        }

        @Generated
        public String getIssuer() {
            return this.issuer;
        }

        @Generated
        public Map<String, List<Object>> getAttributes() {
            return this.attributes;
        }

        @Generated
        public Optional<RegisteredService> getRegisteredService() {
            return this.registeredService;
        }

        @Generated
        public String toString() {
            return "JwtBuilder.JwtRequest(jwtId=" + this.jwtId + ", serviceAudience=" + this.serviceAudience + ", issueDate=" + this.issueDate + ", subject=" + this.subject + ", validUntilDate=" + this.validUntilDate + ", issuer=" + this.issuer + ", attributes=" + this.attributes + ", registeredService=" + this.registeredService + ")";
        }

        @Generated
        private static final class JwtRequestBuilderImpl
        extends JwtRequestBuilder<JwtRequest, JwtRequestBuilderImpl> {
            @Generated
            private JwtRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected JwtRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public JwtRequest build() {
                return new JwtRequest(this);
            }
        }

        @Generated
        public static abstract class JwtRequestBuilder<C extends JwtRequest, B extends JwtRequestBuilder<C, B>> {
            @Generated
            private String jwtId;
            @Generated
            private String serviceAudience;
            @Generated
            private Date issueDate;
            @Generated
            private String subject;
            @Generated
            private Date validUntilDate;
            @Generated
            private String issuer;
            @Generated
            private boolean attributes$set;
            @Generated
            private Map<String, List<Object>> attributes$value;
            @Generated
            private boolean registeredService$set;
            @Generated
            private Optional<RegisteredService> registeredService$value;

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public B jwtId(String jwtId) {
                this.jwtId = jwtId;
                return this.self();
            }

            @Generated
            public B serviceAudience(String serviceAudience) {
                this.serviceAudience = serviceAudience;
                return this.self();
            }

            @Generated
            public B issueDate(Date issueDate) {
                this.issueDate = issueDate;
                return this.self();
            }

            @Generated
            public B subject(String subject) {
                this.subject = subject;
                return this.self();
            }

            @Generated
            public B validUntilDate(Date validUntilDate) {
                this.validUntilDate = validUntilDate;
                return this.self();
            }

            @Generated
            public B issuer(String issuer) {
                this.issuer = issuer;
                return this.self();
            }

            @Generated
            public B attributes(Map<String, List<Object>> attributes) {
                this.attributes$value = attributes;
                this.attributes$set = true;
                return this.self();
            }

            @Generated
            public B registeredService(Optional<RegisteredService> registeredService) {
                this.registeredService$value = registeredService;
                this.registeredService$set = true;
                return this.self();
            }

            @Generated
            public String toString() {
                return "JwtBuilder.JwtRequest.JwtRequestBuilder(jwtId=" + this.jwtId + ", serviceAudience=" + this.serviceAudience + ", issueDate=" + this.issueDate + ", subject=" + this.subject + ", validUntilDate=" + this.validUntilDate + ", issuer=" + this.issuer + ", attributes$value=" + this.attributes$value + ", registeredService$value=" + this.registeredService$value + ")";
            }
        }
    }
}

