/*
 * Decompiled with CFR 0.152.
 */
package com.okta.authn.sdk.http;

import com.okta.authn.sdk.http.Header;
import com.okta.authn.sdk.http.QueryParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RequestContext {
    private final List<Header> headers = new ArrayList<Header>();
    private final List<QueryParameter> queryParams = new ArrayList<QueryParameter>();

    public RequestContext() {
    }

    public RequestContext(List<Header> headers, List<QueryParameter> queryParams) {
        this.headers.addAll(headers);
        this.queryParams.addAll(queryParams);
    }

    public RequestContext(Map<String, List<String>> headers, Map<String, String> queryParams) {
        headers.entrySet().stream().map(entry -> new Header((String)entry.getKey(), (List)entry.getValue())).forEach(this.headers::add);
        queryParams.entrySet().stream().map(entry -> new QueryParameter((String)entry.getKey(), (String)entry.getValue())).forEach(this.queryParams::add);
    }

    public List<Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public List<QueryParameter> getQueryParams() {
        return Collections.unmodifiableList(this.queryParams);
    }

    public RequestContext addHeader(Header header) {
        this.headers.add(header);
        return this;
    }

    public RequestContext addHeader(String key, String value) {
        this.headers.add(Header.header(key, value));
        return this;
    }

    public RequestContext addHeader(String key, List<String> values) {
        this.headers.add(Header.header(key, values));
        return this;
    }

    public RequestContext addQuery(QueryParameter query) {
        this.queryParams.add(query);
        return this;
    }

    public RequestContext addQuery(String key, String value) {
        this.queryParams.add(QueryParameter.query(key, value));
        return this;
    }
}

