/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.JavaFxProvider;
import com.microsoft.alm.oauth2.useragent.StandardWidgetToolkitProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Provider {
    static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    static final String JAVA_HOME = System.getProperty("java.home");
    static final String USER_HOME = System.getProperty("user.home");
    static final String OS_NAME = System.getProperty("os.name");
    static final String OS_VERSION = System.getProperty("os.version");
    static final String OS_ARCH = System.getProperty("os.arch");
    static final String ENV_DISPLAY = System.getenv("DISPLAY");
    public static final Provider JAVA_FX = new JavaFxProvider();
    public static final Provider STANDARD_WIDGET_TOOLKIT = new StandardWidgetToolkitProvider();
    public static final List<Provider> PROVIDERS = Collections.unmodifiableList(Arrays.asList(JAVA_FX, STANDARD_WIDGET_TOOLKIT));
    private final String className;

    protected Provider(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public static boolean isMac(String osName) {
        return osName.equals("Mac OS X");
    }

    public static boolean isLinux(String osName) {
        return osName.equals("Linux");
    }

    public static boolean isWindows(String osName) {
        return osName.startsWith("Windows");
    }

    public abstract List<String> checkRequirements();

    public abstract void augmentProcessParameters(List<String> var1, List<String> var2);

    static boolean hasDesktop(String osName, String displayVariable) {
        boolean hasDesktop = false;
        if (Provider.isWindows(osName)) {
            hasDesktop = true;
        } else if (Provider.isMac(osName)) {
            hasDesktop = true;
        } else if (Provider.isLinux(osName) && displayVariable != null) {
            hasDesktop = true;
        }
        return hasDesktop;
    }
}

