/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.print.PrintXmlLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPrintXmlLoader {
    private static final Log log = LogFactory.getLog(JRPrintXmlLoader.class);
    private final JasperReportsContext jasperReportsContext;

    protected JRPrintXmlLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public static JasperPrint loadFromFile(JasperReportsContext jasperReportsContext, String sourceFileName) throws JRException {
        JasperPrint jasperPrint = null;
        try (FileInputStream fis = new FileInputStream(sourceFileName);){
            JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader(jasperReportsContext);
            jasperPrint = printXmlLoader.loadXML(fis);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        return jasperPrint;
    }

    public static JasperPrint loadFromFile(String sourceFileName) throws JRException {
        return JRPrintXmlLoader.loadFromFile(DefaultJasperReportsContext.getInstance(), sourceFileName);
    }

    public static JasperPrint load(String sourceFileName) throws JRException {
        return JRPrintXmlLoader.loadFromFile(sourceFileName);
    }

    public static JasperPrint load(JasperReportsContext jasperReportsContext, InputStream is) throws JRException {
        JasperPrint jasperPrint = null;
        JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader(jasperReportsContext);
        jasperPrint = printXmlLoader.loadXML(is);
        return jasperPrint;
    }

    public static JasperPrint load(InputStream is) throws JRException {
        return JRPrintXmlLoader.load(DefaultJasperReportsContext.getInstance(), is);
    }

    private JasperPrint loadXML(InputStream is) throws JRException {
        PrintXmlLoader loader = new PrintXmlLoader();
        return loader.load(is);
    }
}

