/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;

public class ExecutionAttemptMappingProvider {
    private final List<ExecutionVertex> tasks = new ArrayList<ExecutionVertex>();
    private Map<ExecutionAttemptID, ExecutionVertex> cachedTasksById;

    public ExecutionAttemptMappingProvider(Iterable<ExecutionVertex> tasksIterable) {
        tasksIterable.forEach(this.tasks::add);
        this.cachedTasksById = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasks.size());
    }

    public Optional<ExecutionVertex> getVertex(ExecutionAttemptID id) {
        ExecutionVertex vertex = this.cachedTasksById.get(id);
        if (vertex != null || this.cachedTasksById.containsKey(id)) {
            return Optional.ofNullable(vertex);
        }
        return this.updateAndGet(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ExecutionVertex> updateAndGet(ExecutionAttemptID id) {
        List<ExecutionVertex> list = this.tasks;
        synchronized (list) {
            ExecutionVertex vertex = this.cachedTasksById.get(id);
            if (vertex != null || this.cachedTasksById.containsKey(id)) {
                return Optional.ofNullable(vertex);
            }
            Map<ExecutionAttemptID, ExecutionVertex> mappings = this.getCurrentAttemptMappings();
            if (!mappings.containsKey(id)) {
                mappings.put(id, null);
            }
            this.cachedTasksById = mappings;
            return Optional.ofNullable(this.cachedTasksById.get(id));
        }
    }

    private Map<ExecutionAttemptID, ExecutionVertex> getCurrentAttemptMappings() {
        HashMap<ExecutionAttemptID, ExecutionVertex> attemptMappings = new HashMap<ExecutionAttemptID, ExecutionVertex>(this.tasks.size());
        for (ExecutionVertex task : this.tasks) {
            attemptMappings.put(task.getCurrentExecutionAttempt().getAttemptId(), task);
        }
        return attemptMappings;
    }
}

