/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.CreateOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CreateOptionsFluent<A extends CreateOptionsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private List<String> dryRun = new ArrayList<String>();
    private String fieldManager;
    private String fieldValidation;
    private String kind;

    public CreateOptionsFluent() {
    }

    public CreateOptionsFluent(CreateOptions instance) {
        this.copyInstance(instance);
    }

    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)((Object)this);
    }

    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(CreateOptions instance) {
        CreateOptions createOptions = instance = instance != null ? instance : new CreateOptions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDryRun(instance.getDryRun());
            this.withFieldManager(instance.getFieldManager());
            this.withFieldValidation(instance.getFieldValidation());
            this.withKind(instance.getKind());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CreateOptionsFluent that = (CreateOptionsFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.dryRun, that.dryRun)) {
            return false;
        }
        if (!Objects.equals(this.fieldManager, that.fieldManager)) {
            return false;
        }
        if (!Objects.equals(this.fieldValidation, that.fieldValidation)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public List<String> getDryRun() {
        return this.dryRun;
    }

    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public String getFieldManager() {
        return this.fieldManager;
    }

    public String getFieldValidation() {
        return this.fieldValidation;
    }

    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public String getKind() {
        return this.kind;
    }

    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    public boolean hasFieldManager() {
        return this.fieldManager != null;
    }

    public boolean hasFieldValidation() {
        return this.fieldValidation != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.fieldManager, this.fieldValidation, this.kind, this.additionalProperties);
    }

    public A removeAllFromDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromDryRun(String ... items) {
        if (this.dryRun == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun);
            sb.append(",");
        }
        if (this.fieldManager != null) {
            sb.append("fieldManager:");
            sb.append(this.fieldManager);
            sb.append(",");
        }
        if (this.fieldValidation != null) {
            sb.append("fieldValidation:");
            sb.append(this.fieldValidation);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)((Object)this);
    }

    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
            this._visitables.remove((Object)"dryRun");
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFieldManager(String fieldManager) {
        this.fieldManager = fieldManager;
        return (A)((Object)this);
    }

    public A withFieldValidation(String fieldValidation) {
        this.fieldValidation = fieldValidation;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }
}

