/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientUtils$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.scheduler.ExecutorDecommission;
import org.apache.spark.scheduler.ExecutorDecommission$;
import org.apache.spark.scheduler.ExecutorDecommissionInfo;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.GenerateExecID;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dg!B\u001b7\u0001q\u0012\u0005\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A\u0011\u000e\u0001B\u0001B\u0003%!\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011i\u0004!\u0011!Q\u0001\nmDQA \u0001\u0005\u0002}D\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005M\u0002\u0001)A\u0005\u00033A\u0011\"!\u000e\u0001\u0005\u0004%\t&a\u000e\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003sA\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000fB\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005u\u0003\u0001)A\u0005\u0003'B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005=\u0004\u0001)A\u0005\u0003GB\u0011\"!\u001d\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005M\u0004\u0001)A\u0005\u00033A\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005\r\u0005\u0001)A\u0005\u0003sB\u0001\"!\"\u0001\t\u00031\u0014q\u0011\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\tY\f\u0001C!\u0003{Cq!a0\u0001\t\u0003\n\t\rC\u0004\u0002D\u0002!\t%!1\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0007bBAq\u0001\u0011\u0005\u00131\u001d\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqA!\u0002\u0001\t\u0003\u00129\u0001C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t=\u0002\u0001\"\u0011\u00032!I!1\b\u0001C\u0002\u0013\u0005!Q\b\u0005\t\u0005\u0017\u0002\u0001\u0015!\u0003\u0003@!9!Q\n\u0001\u0005R\t=\u0003b\u0002B2\u0001\u0011E#Q\r\u0004\u0007\u0005[\u0002AAa\u001c\t\rydC\u0011\u0001B9\u0011%\u0011)\b\fb\u0001\n#\u00119\b\u0003\u0005\u0003\u00162\u0002\u000b\u0011\u0002B=\u0011\u001d\u00119\n\fC\u0005\u00053CqA!--\t\u0013\u0011\u0019\fC\u0004\u000362\"\tEa.\t\u000f\tmF\u0006\"\u0011\u0003>\"q!1\u0019\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002B\n\u0015'!I&vE\u0016\u0014h.\u001a;fg\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u001c9\u0003\rY\u0007h\u001d\u0006\u0003si\nqa\u00197vgR,'O\u0003\u0002<y\u0005I1o\u00195fIVdWM\u001d\u0006\u0003{y\nQa\u001d9be.T!a\u0010!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0015aA8sON\u0011\u0001a\u0011\t\u0003\t\u0016k\u0011\u0001O\u0005\u0003\rb\u0012QdQ8beN,wI]1j]\u0016$7k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0002\u0001!\tI%*D\u0001;\u0013\tY%HA\tUCN\\7k\u00195fIVdWM]%na2\f!a]2\u0011\u00059{U\"\u0001\u001f\n\u0005Ac$\u0001D*qCJ\\7i\u001c8uKb$\u0018\u0001E6vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u!\t\u0019F,D\u0001U\u0015\t)f+\u0001\u0004dY&,g\u000e\u001e\u0006\u0003/b\u000b!b[;cKJtW\r^3t\u0015\tI&,A\u0004gC\n\u0014\u0018n\u0019\u001d\u000b\u0003m\u000b!![8\n\u0005u#&\u0001E&vE\u0016\u0014h.\u001a;fg\u000ec\u0017.\u001a8u\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,\u0007C\u00011h\u001b\u0005\t'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u0016\fA!\u001e;jY*\ta-\u0001\u0003kCZ\f\u0017B\u00015b\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u000fg:\f\u0007o\u001d5piN\u001cFo\u001c:f!\tYG.D\u00017\u0013\tigG\u0001\u000eFq\u0016\u001cW\u000f^8s!>$7o\u00158baNDw\u000e^:Ti>\u0014X-\u0001\u0007q_\u0012\fE\u000e\\8dCR|'\u000f\u0005\u0002la&\u0011\u0011O\u000e\u0002\u0016\u0003\n\u001cHO]1diB{Gm]!mY>\u001c\u0017\r^8s\u0003Aa\u0017NZ3ds\u000edW-T1oC\u001e,'\u000f\u0005\u0002li&\u0011QO\u000e\u0002\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0003-9\u0018\r^2i\u000bZ,g\u000e^:\u0011\u0005-D\u0018BA=7\u0005})\u00050Z2vi>\u0014\bk\u001c3t/\u0006$8\r[*oCB\u001c\bn\u001c;T_V\u00148-Z\u0001\u000ba>dG.\u0012<f]R\u001c\bCA6}\u0013\tihGA\u0011Fq\u0016\u001cW\u000f^8s!>$7\u000fU8mY&twm\u00158baNDw\u000e^*pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0005-\u0004\u0001\"B\u001e\u000b\u0001\u0004A\u0005\"\u0002'\u000b\u0001\u0004i\u0005\"B)\u000b\u0001\u0004\u0011\u0006\"\u00020\u000b\u0001\u0004y\u0006\"B5\u000b\u0001\u0004Q\u0007\"\u00028\u000b\u0001\u0004y\u0007\"\u0002:\u000b\u0001\u0004\u0019\b\"\u0002<\u000b\u0001\u00049\b\"\u0002>\u000b\u0001\u0004Y\u0018!B1qa&#WCAA\r!\u0011\tY\"!\f\u000f\t\u0005u\u0011\u0011\u0006\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111E$\u0002\rq\u0012xn\u001c;?\u0015\t\t9#A\u0003tG\u0006d\u0017-\u0003\u0003\u0002,\u0005\u0015\u0012A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twM\u0003\u0003\u0002,\u0005\u0015\u0012AB1qa&#\u0007%\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|WCAA\u001d!\u0011\tY$!\u0010\u000e\u0005\u0005\u0015\u0012\u0002BA \u0003K\u0011a\u0001R8vE2,\u0017aE7j]J+w-[:uKJ,GMU1uS>\u0004\u0013\u0001E5oSRL\u0017\r\\#yK\u000e,Ho\u001c:t+\t\t9\u0005\u0005\u0003\u0002<\u0005%\u0013\u0002BA&\u0003K\u00111!\u00138u\u0003EIg.\u001b;jC2,\u00050Z2vi>\u00148\u000fI\u0001\u001ag\"|W\u000f\u001c3EK2,G/\u001a#sSZ,'oU3sm&\u001cW-\u0006\u0002\u0002TA!\u00111HA+\u0013\u0011\t9&!\n\u0003\u000f\t{w\u000e\\3b]\u0006Q2\u000f[8vY\u0012$U\r\\3uK\u0012\u0013\u0018N^3s'\u0016\u0014h/[2fA\u0005)2\u000f[8vY\u0012$U\r\\3uK\u0016CXmY;u_J\u001c\u0018AF:i_VdG\rR3mKR,W\t_3dkR|'o\u001d\u0011\u0002\u001d\u0011,g-Y;miB\u0013xNZ5mKV\u0011\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u001f\u0002\u0011I,7o\\;sG\u0016LA!!\u001c\u0002h\ty!+Z:pkJ\u001cW\r\u0015:pM&dW-A\beK\u001a\fW\u000f\u001c;Qe>4\u0017\u000e\\3!\u0003%q\u0017-\\3ta\u0006\u001cW-\u0001\u0006oC6,7\u000f]1dK\u0002\n\u0011\u0004]8e\t\u0016dW\r^5p]\u000e{7\u000f^!o]>$\u0018\r^5p]V\u0011\u0011\u0011\u0010\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)\u0019\u0011qP3\u0002\t1\fgnZ\u0005\u0005\u0003_\ti(\u0001\u000eq_\u0012$U\r\\3uS>t7i\\:u\u0003:tw\u000e^1uS>t\u0007%\u0001\te_J+Wn\u001c<f\u000bb,7-\u001e;peR1\u0011\u0011RAH\u0003'\u0003B!a\u000f\u0002\f&!\u0011QRA\u0013\u0005\u0011)f.\u001b;\t\u000f\u0005E5\u00041\u0001\u0002\u001a\u0005QQ\r_3dkR|'/\u00133\t\u000f\u0005U5\u00041\u0001\u0002\u0018\u00061!/Z1t_:\u00042!SAM\u0013\r\tYJ\u000f\u0002\u0013\u000bb,7-\u001e;pe2{7o\u001d*fCN|g.\u0001\ftKR,\u0006/\u0012=fGV$xN]\"p]\u001aLw-T1q)\u0011\tI)!)\t\u000f\u0005\rF\u00041\u0001\u0002&\u0006IAM]5wKJ\u0004v\u000e\u001a\t\u0007\u0003w\t9+a+\n\t\u0005%\u0016Q\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u0006)Qn\u001c3fY*\u0019\u0011Q\u0017,\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002:\u0006=&a\u0001)pI\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012$\"!!\u0007\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005%\u0015\u0001B:u_B\fq\u0003Z8SKF,Xm\u001d;U_R\fG.\u0012=fGV$xN]:\u0015\t\u0005%\u00171\u001b\t\u0007\u0003\u0017\fy-a\u0015\u000e\u0005\u00055'b\u00012\u0002&%!\u0011\u0011[Ag\u0005\u00191U\u000f^;sK\"9\u0011Q\u001b\u0011A\u0002\u0005]\u0017a\u0007:fg>,(oY3Qe>4\u0017\u000e\\3U_R{G/\u00197Fq\u0016\u001c7\u000f\u0005\u0005\u0002\u001c\u0005e\u00171MA$\u0013\u0011\tY.!\r\u0003\u00075\u000b\u0007/A\u000ftk\u001a4\u0017nY5f]R\u0014Vm]8ve\u000e,7OU3hSN$XM]3e)\t\t\u0019&\u0001\bhKR,\u00050Z2vi>\u0014\u0018\nZ:\u0015\u0005\u0005\u0015\bCBAt\u0003c\fIB\u0004\u0003\u0002j\u00065h\u0002BA\u0010\u0003WL!!a\n\n\t\u0005=\u0018QE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u00190!>\u0003\u0007M+\u0017O\u0003\u0003\u0002p\u0006\u0015\u0012\u0001H1o]>$\u0018\r^3Fq\u0016\u001cW\u000f^8s\t\u0016dW\r^5p]\u000e{7\u000f\u001e\u000b\u0005\u0003\u0013\u000bY\u0010C\u0004\u0002~\u000e\u0002\r!!:\u0002\u000f\u0015DXmY%eg\u0006IB.\u00192fY\u0012+7m\\7nSN\u001c\u0018n\u001c8j]\u001e,\u00050Z2t)\u0011\tIIa\u0001\t\u000f\u0005uH\u00051\u0001\u0002f\u0006)B-Z2p[6L7o]5p]\u0016CXmY;u_J\u001cH\u0003CAs\u0005\u0013\u0011yBa\t\t\u000f\t-Q\u00051\u0001\u0003\u000e\u0005)R\r_3dkR|'o]!oI\u0012+7m\\7J]\u001a|\u0007CBA\u001e\u0005\u001f\u0011\u0019\"\u0003\u0003\u0003\u0012\u0005\u0015\"!B!se\u0006L\b\u0003CA\u001e\u0005+\tIB!\u0007\n\t\t]\u0011Q\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007%\u0013Y\"C\u0002\u0003\u001ei\u0012\u0001$\u0012=fGV$xN\u001d#fG>lW.[:tS>t\u0017J\u001c4p\u0011\u001d\u0011\t#\na\u0001\u0003'\n\u0001$\u00193kkN$H+\u0019:hKRtU/\\#yK\u000e,Ho\u001c:t\u0011\u001d\u0011)#\na\u0001\u0003'\n1\u0003\u001e:jO\u001e,'/\u001a3Cs\u0016CXmY;u_J\fq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0003\u0013\u0014Y\u0003C\u0004\u0003.\u0019\u0002\r!!:\u0002\u0017\u0015DXmY;u_JLEm]\u0001\u0015GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;\u0015\u0005\tM\u0002\u0003\u0002B\u001b\u0005oi\u0011\u0001A\u0005\u0004\u0005s)%A\u0004#sSZ,'/\u00128ea>Lg\u000e^\u0001\u0007Kb,7-\u00133\u0016\u0005\t}\u0002\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\u0007\t\u0015\u0013-\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005\u0013\u0012\u0019EA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\bKb,7-\u00133!\u0003I\u0019'/Z1uKR{7.\u001a8NC:\fw-\u001a:\u0015\u0005\tE\u0003CBA\u001e\u0003O\u0013\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\u0011M,7-\u001e:jifT1A!\u0018=\u0003\u0019!W\r\u001d7ps&!!\u0011\rB,\u0005qA\u0015\rZ8pa\u0012+G.Z4bi&|g\u000eV8lK:l\u0015M\\1hKJ\f!#[:Fq\u0016\u001cW\u000f^8s\u000bb\u001cG.\u001e3fIR1\u00111\u000bB4\u0005SBq!!%,\u0001\u0004\tI\u0002C\u0004\u0003l-\u0002\r!!\u0007\u0002\u0011!|7\u000f\u001e8b[\u0016\u0014\u0001dS;cKJtW\r^3t\tJLg/\u001a:F]\u0012\u0004x.\u001b8u'\ra#1\u0007\u000b\u0003\u0005g\u00022A!\u000e-\u0003=)\u00070Z2J\tJ+\u0017/^3ti\u0016\u0014XC\u0001B=!!\u0011YH!\"\u0003\n\u0006eQB\u0001B?\u0015\u0011\u0011yH!!\u0002\u000f5,H/\u00192mK*!!1QA\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\u0013iHA\u0004ICNDW*\u00199\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bS1Aa$=\u0003\r\u0011\boY\u0005\u0005\u0005'\u0013iI\u0001\u0006Sa\u000e\fE\r\u001a:fgN\f\u0001#\u001a=fG&#%+Z9vKN$XM\u001d\u0011\u0002\u001d\u001d,g.\u001a:bi\u0016,\u00050Z2J\tR!!1\u0014BT!!\tYD!(\u0003\"\u0006%\u0015\u0002\u0002BP\u0003K\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0005\u0003w\u0011\u0019+\u0003\u0003\u0003&\u0006\u0015\"aA!os\"9!\u0011\u0016\u0019A\u0002\t-\u0016aB2p]R,\u0007\u0010\u001e\t\u0005\u0005\u0017\u0013i+\u0003\u0003\u00030\n5%A\u0004*qG\u000e\u000bG\u000e\\\"p]R,\u0007\u0010^\u0001'S\u001etwN]3SK\u001eL7\u000f^3s\u000bb,7-\u001e;pe\u0006#8\u000b^8qa\u0016$7i\u001c8uKb$XC\u0001BN\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003\u0002BN\u0005sCqA!+3\u0001\u0004\u0011Y+\u0001\bp]\u0012K7oY8o]\u0016\u001cG/\u001a3\u0015\t\u0005%%q\u0018\u0005\b\u0005\u0003\u001c\u0004\u0019\u0001BE\u0003)\u0011\boY!eIJ,7o]\u0001\u000bgV\u0004XM\u001d\u0013ti>\u0004\u0018bAAb\u000b\u0002")
public class KubernetesClusterSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc;
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient;
    public final ScheduledExecutorService org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final AbstractPodsAllocator podAllocator;
    private final ExecutorPodsLifecycleManager lifecycleManager;
    private final ExecutorPodsWatchSnapshotSource watchEvents;
    private final ExecutorPodsPollingSnapshotSource pollEvents;
    private final String appId;
    private final double minRegisteredRatio;
    private final int initialExecutors;
    private final boolean shouldDeleteDriverService;
    private final boolean shouldDeleteExecutors;
    private final ResourceProfile defaultProfile;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    private final String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation;
    private final AtomicInteger execId;

    private /* synthetic */ void super$stop() {
        super.stop();
    }

    private String appId() {
        return this.appId;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    private int initialExecutors() {
        return this.initialExecutors;
    }

    private boolean shouldDeleteDriverService() {
        return this.shouldDeleteDriverService;
    }

    private boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    private ResourceProfile defaultProfile() {
        return this.defaultProfile;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace;
    }

    public String org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation() {
        return this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation;
    }

    public void doRemoveExecutor(String executorId, ExecutorLossReason reason) {
        this.removeExecutor(executorId, reason);
    }

    private void setUpExecutorConfigMap(Option<Pod> driverPod) {
        String configMapName = KubernetesClientUtils$.MODULE$.configMapNameExecutor();
        Map resolvedExecutorProperties = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key()), (Object)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())}));
        Map confFilesMap = (Map)KubernetesClientUtils$.MODULE$.buildSparkConfDirFilesMap(configMapName, this.conf(), (Map<String, String>)resolvedExecutorProperties).$plus$plus((IterableOnce)resolvedExecutorProperties);
        Map labels = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.applicationId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}));
        ConfigMap configMap = KubernetesClientUtils$.MODULE$.buildConfigMap(configMapName, (Map<String, String>)confFilesMap, (Map<String, String>)labels);
        KubernetesUtils$.MODULE$.addOwnerReference((Pod)driverPod.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<HasMetadata>)new .colon.colon((Object)configMap, (List)Nil$.MODULE$));
        ((CreateOrReplaceable)((AnyNamespaceOperation)this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).resource((Object)configMap)).create();
    }

    public String applicationId() {
        return (String)this.conf().getOption("spark.app.id").getOrElse((Function0 & Serializable)() -> this.appId());
    }

    public void start() {
        super.start();
        this.podAllocator.start(this.applicationId(), this);
        Map initExecs = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.defaultProfile()), (Object)BoxesRunTime.boxToInteger((int)this.initialExecutors()))}));
        this.podAllocator.setTotalExpectedExecutors((Map<ResourceProfile, Object>)initExecs);
        this.lifecycleManager.start(this);
        this.watchEvents.start(this.applicationId());
        this.pollEvents.start(this.applicationId());
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
            this.setUpExecutorConfigMap(this.podAllocator.driverPod());
            return;
        }
    }

    public void stop() {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.snapshotsStore.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.watchEvents.stop());
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.pollEvents.stop());
        if (this.shouldDeleteDriverService()) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.services().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC()))) {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.persistentVolumeClaims().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).delete());
        }
        if (this.shouldDeleteExecutors()) {
            this.podAllocator.stop(this.applicationId());
            if (!BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DISABLE_CONFIGMAP()))) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.configMaps().inNamespace(this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
            }
        }
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ThreadUtils$.MODULE$.shutdown((ExecutorService)$this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService, ThreadUtils$.MODULE$.shutdown$default$2()));
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.close());
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        this.podAllocator.setTotalExpectedExecutors(resourceProfileToTotalExecs);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.initialExecutors() * this.minRegisteredRatio();
    }

    public synchronized Seq<String> getExecutorIds() {
        return super.getExecutorIds();
    }

    private void annotateExecutorDeletionCost(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_DELETION_COST())).foreach((Function1)(JFunction1.mcVI.sp & Serializable)cost -> {
            this.logInfo((Function0 & Serializable)() -> "Annotating executor pod(s) " + execIds.mkString(",") + " with deletion cost " + cost);
            Runnable annotateTask = new Runnable(this, execIds, cost){
                private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
                private final Seq execIds$1;
                private final int cost$1;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$1.toArray(ClassTag$.MODULE$.apply(String.class)))).resources().forEach(podResource -> podResource.edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editOrNewMetadata().addToAnnotations($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation(), Integer.toString($this.cost$1))).endMetadata()).build())));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execIds$1 = execIds$1;
                    this.cost$1 = cost$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$1 )}, serializedLambda);
                }
            };
            $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(annotateTask);
        });
    }

    private void labelDecommissioningExecs(Seq<String> execIds) {
        ((Option)this.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL())).foreach((Function1 & Serializable)label -> {
            KubernetesClusterSchedulerBackend.$anonfun$labelDecommissioningExecs$1(this, execIds, label);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<String> decommissionExecutors(Tuple2<String, ExecutorDecommissionInfo>[] executorsAndDecomInfo, boolean adjustTargetNumExecutors, boolean triggeredByExecutor) {
        block1: {
            if (triggeredByExecutor) break block1;
            this.labelDecommissioningExecs((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo), (Function1 & Serializable)x$1 -> (String)x$1._1(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
            if (((String)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR())).equals("deployment")) {
                this.annotateExecutorDeletionCost((Seq<String>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])executorsAndDecomInfo), (Function1 & Serializable)x$2 -> (String)x$2._1(), ClassTag$.MODULE$.apply(String.class))).toImmutableArraySeq());
            }
        }
        return super.decommissionExecutors(executorsAndDecomInfo, adjustTargetNumExecutors, triggeredByExecutor);
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        if (((String)this.conf().get(Config$.MODULE$.KUBERNETES_ALLOCATION_PODS_ALLOCATOR())).equals("deployment")) {
            this.annotateExecutorDeletionCost(executorIds);
        }
        this.labelDecommissioningExecs(executorIds);
        executorIds.foreach((Function1 & Serializable)id -> {
            this.removeExecutor(id, (ExecutorLossReason)ExecutorKilled$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Runnable killTask = new Runnable(this, executorIds){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq executorIds$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    FilterWatchListDeletable running = (FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withField("status.phase", "Running")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.executorIds$1.toArray(ClassTag$.MODULE$.apply(String.class)));
                    if (!((PodList)running.list()).getItems().isEmpty()) {
                        $this.$outer.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Forcefully deleting ", " pods "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)((PodList)running.list()).getItems().size()))})).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(out of ", ") that are still running after graceful "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.TOTAL, BoxesRunTime.boxToInteger((int)$this.executorIds$1.size()))}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"shutdown period."}))).log((Seq)Nil$.MODULE$))));
                        running.delete();
                        return;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executorIds$1 = executorIds$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$8(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$3 ), $anonfun$run$9(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$3 io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable )}, serializedLambda);
            }
        };
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.schedule(killTask, BoxesRunTime.unboxToLong((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DYN_ALLOC_KILL_GRACE_PERIOD())), TimeUnit.MILLISECONDS);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new KubernetesDriverEndpoint(this);
    }

    public AtomicInteger execId() {
        return this.execId;
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.conf(), this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public boolean isExecutorExcluded(String executorId, String hostname) {
        return this.podAllocator.isDeleted(executorId);
    }

    public static final /* synthetic */ void $anonfun$labelDecommissioningExecs$1(KubernetesClusterSchedulerBackend $this, Seq execIds$2, String label) {
        Runnable labelTask = new Runnable($this, execIds$2, label){
            private final /* synthetic */ KubernetesClusterSchedulerBackend $outer;
            private final Seq execIds$2;
            private final String label$1;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((FilterWatchListDeletable)((Filterable)((Filterable)((Filterable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), $this.$outer.applicationId())).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])$this.execIds$2.toArray(ClassTag$.MODULE$.apply(String.class)))).resources().forEach(podResource -> podResource.edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editOrNewMetadata().addToLabels($this.label$1, (String)((Option)$this.$outer.conf().get(Config$.MODULE$.KUBERNETES_EXECUTOR_DECOMMISSION_LABEL_VALUE())).getOrElse((Function0 & Serializable)() -> ""))).endMetadata()).build())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.execIds$2 = execIds$2;
                this.label$1 = label$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$$anon$2 ), $anonfun$run$7()}, serializedLambda);
            }
        };
        $this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
    }

    public KubernetesClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc, KubernetesClient kubernetesClient, ScheduledExecutorService executorService, ExecutorPodsSnapshotsStore snapshotsStore, AbstractPodsAllocator podAllocator, ExecutorPodsLifecycleManager lifecycleManager, ExecutorPodsWatchSnapshotSource watchEvents, ExecutorPodsPollingSnapshotSource pollEvents) {
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc = sc;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient = kubernetesClient;
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService = executorService;
        this.snapshotsStore = snapshotsStore;
        this.podAllocator = podAllocator;
        this.lifecycleManager = lifecycleManager;
        this.watchEvents = watchEvents;
        this.pollEvents = pollEvents;
        super(scheduler, sc.env().rpcEnv());
        this.appId = KubernetesConf$.MODULE$.getKubernetesAppId();
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.initialExecutors = SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2());
        this.shouldDeleteDriverService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_DELETE_ON_TERMINATION()));
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)this.conf().get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.defaultProfile = scheduler.sc().resourceProfileManager().defaultResourceProfile();
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace = (String)this.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$podDeletionCostAnnotation = "controller.kubernetes.io/pod-deletion-cost";
        this.execId = new AtomicInteger(0);
    }

    private class KubernetesDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        private final HashMap<RpcAddress, String> execIDRequester = new HashMap();

        public HashMap<RpcAddress, String> execIDRequester() {
            return this.execIDRequester;
        }

        private PartialFunction<Object, BoxedUnit> generateExecID(RpcCallContext context) {
            return new Serializable(this, context){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof GenerateExecID) {
                        GenerateExecID generateExecID2 = (GenerateExecID)A1;
                        String newId = Integer.toString(this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().execId().incrementAndGet());
                        this.context$1.reply((Object)newId);
                        RpcAddress executorAddress = this.context$1.senderAddress();
                        this.$outer.execIDRequester().update((Object)executorAddress, (Object)newId);
                        Runnable labelTask = new Runnable(this, generateExecID2, newId){
                            private final /* synthetic */ KubernetesDriverEndpoint$$anonfun$generateExecID$1 $outer;
                            private final GenerateExecID x2$1;
                            private final String newId$1;

                            public void run() {
                                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((EditReplacePatchable)((Nameable)$this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$kubernetesClient.pods().inNamespace($this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$namespace())).withName($this.x2$1.podName())).edit(p -> ((PodBuilder)((PodFluent.MetadataNested)new PodBuilder(p).editMetadata().addToLabels(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), $this.newId$1)).endMetadata()).build()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x2$1 = x2$1;
                                this.newId$1 = newId$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$10(org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$generateExecID$1$$anon$4 )}, serializedLambda);
                            }
                        };
                        this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$executorService.execute(labelTask);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof GenerateExecID;
                }

                public /* synthetic */ KubernetesDriverEndpoint org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        private PartialFunction<Object, BoxedUnit> ignoreRegisterExecutorAtStoppedContext() {
            return new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ KubernetesDriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof CoarseGrainedClusterMessages.RegisterExecutor && this.$outer.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$$sc.isStopped();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return this.generateExecID(context).orElse(this.ignoreRegisterExecutorAtStoppedContext().orElse(super.receiveAndReply(context)));
        }

        public void onDisconnected(RpcAddress rpcAddress) {
            Option execId = this.addressToExecutorId().get((Object)rpcAddress);
            Option option = execId;
            if (option instanceof Some) {
                Some some = (Some)option;
                String id = (String)some.value();
                Option option2 = this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().executorsPendingDecommission().get((Object)id);
                if (option2 instanceof Some) {
                    this.org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer().removeExecutor(id, (ExecutorLossReason)new ExecutorDecommission((Option)None$.MODULE$, ExecutorDecommission$.MODULE$.apply$default$2()));
                } else {
                    this.disableExecutor(id);
                }
                return;
            }
            Option newExecId = this.execIDRequester().get((Object)rpcAddress);
            Option option3 = newExecId;
            if (option3 instanceof Some) {
                this.execIDRequester().$minus$eq((Object)rpcAddress);
            } else {
                this.logDebug((Function0 & Serializable)() -> "No executor found for " + rpcAddress);
            }
        }

        public /* synthetic */ KubernetesClusterSchedulerBackend org$apache$spark$scheduler$cluster$k8s$KubernetesClusterSchedulerBackend$KubernetesDriverEndpoint$$$outer() {
            return (KubernetesClusterSchedulerBackend)this.$outer;
        }

        public KubernetesDriverEndpoint(KubernetesClusterSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }
}

