/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r3AAB\u0004\u0001%!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003.\u0001\u0011\u0005c\u0006C\u00036\u0001\u0011%a\u0007C\u0003@\u0001\u0011\u0005\u0003IA\nEKR,'/\\5oKR\u000b'\r\\3Ti\u0006$8O\u0003\u0002\t\u0013\u0005!\u0001.\u001b<f\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\t\u00011\u0003E\u0002\u00153mi\u0011!\u0006\u0006\u0003-]\tQA];mKNT!\u0001G\u0005\u0002\u0011\r\fG/\u00197zgRL!AG\u000b\u0003\tI+H.\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tq\u0001\\8hS\u000e\fGN\u0003\u0002!/\u0005)\u0001\u000f\\1og&\u0011!%\b\u0002\f\u0019><\u0017nY1m!2\fg.A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\u00152S\"A\u0005\n\u0005\u001dJ!\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002+YA\u00111\u0006A\u0007\u0002\u000f!)1E\u0001a\u0001I\u0005!1m\u001c8g+\u0005y\u0003C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\n\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001b2\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\f!\u0003[5wKR\u000b'\r\\3XSRD7\u000b^1ugR\u0011q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0003u]\tqaY1uC2|w-\u0003\u0002=s\t\t\u0002*\u001b<f)\u0006\u0014G.\u001a*fY\u0006$\u0018n\u001c8\t\u000by\"\u0001\u0019A\u001c\u0002\u0011I,G.\u0019;j_:\fQ!\u00199qYf$\"aG!\t\u000b\t+\u0001\u0019A\u000e\u0002\tAd\u0017M\u001c")
public class DetermineTableStats
extends Rule<LogicalPlan> {
    private final SparkSession session;

    public SQLConf conf() {
        return this.session.sessionState().conf();
    }

    public HiveTableRelation org$apache$spark$sql$hive$DetermineTableStats$$hiveTableWithStats(HiveTableRelation relation) {
        Some stats;
        long l;
        CatalogTable table = relation.tableMeta();
        Seq partitionCols = relation.partitionCols();
        if (this.conf().fallBackToHdfsForStatsEnabled() && partitionCols.isEmpty()) {
            try {
                Configuration hadoopConf = this.session.sessionState().newHadoopConf();
                Path tablePath = new Path(table.location());
                FileSystem fs = tablePath.getFileSystem(hadoopConf);
                l = fs.getContentSummary(tablePath).getLength();
            }
            catch (IOException e) {
                this.logWarning((Function0 & Serializable)() -> "Failed to get table size from HDFS.", e);
                l = this.conf().defaultSizeInBytes();
            }
        } else {
            l = this.conf().defaultSizeInBytes();
        }
        long sizeInBytes = l;
        Some x$1 = stats = new Some((Object)new Statistics(package$.MODULE$.BigInt().apply(sizeInBytes), Statistics$.MODULE$.apply$default$2(), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4()));
        CatalogTable x$2 = relation.copy$default$1();
        Seq x$3 = relation.copy$default$2();
        Seq x$4 = relation.copy$default$3();
        Option x$5 = relation.copy$default$5();
        return relation.copy(x$2, x$3, x$4, (Option)x$1, x$5);
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.resolveOperators((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DetermineTableStats $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HiveTableRelation hiveTableRelation;
                InsertIntoStatement insertIntoStatement;
                LogicalPlan relation;
                HiveTableRelation hiveTableRelation2;
                A1 A1 = x1;
                if (A1 instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation2 = (HiveTableRelation)A1).tableMeta()) && hiveTableRelation2.tableMeta().stats().isEmpty()) {
                    return (B1)this.$outer.org$apache$spark$sql$hive$DetermineTableStats$$hiveTableWithStats(hiveTableRelation2);
                }
                if (A1 instanceof InsertIntoStatement && (relation = (insertIntoStatement = (InsertIntoStatement)A1).table()) instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)relation).tableMeta()) && hiveTableRelation.tableMeta().stats().isEmpty()) {
                    return (B1)insertIntoStatement.copy((LogicalPlan)this.$outer.org$apache$spark$sql$hive$DetermineTableStats$$hiveTableWithStats(hiveTableRelation), insertIntoStatement.copy$default$2(), insertIntoStatement.copy$default$3(), insertIntoStatement.copy$default$4(), insertIntoStatement.copy$default$5(), insertIntoStatement.copy$default$6(), insertIntoStatement.copy$default$7(), insertIntoStatement.copy$default$8());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HiveTableRelation hiveTableRelation;
                InsertIntoStatement insertIntoStatement;
                LogicalPlan relation;
                HiveTableRelation hiveTableRelation2;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation2 = (HiveTableRelation)logicalPlan).tableMeta()) && hiveTableRelation2.tableMeta().stats().isEmpty()) {
                    return true;
                }
                return logicalPlan instanceof InsertIntoStatement && (relation = (insertIntoStatement = (InsertIntoStatement)logicalPlan).table()) instanceof HiveTableRelation && DDLUtils$.MODULE$.isHiveTable((hiveTableRelation = (HiveTableRelation)relation).tableMeta()) && hiveTableRelation.tableMeta().stats().isEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public DetermineTableStats(SparkSession session) {
        this.session = session;
    }
}

