/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DefaultParamsReader$ {
    public static final DefaultParamsReader$ MODULE$ = new DefaultParamsReader$();

    public DefaultParamsReader.Metadata loadMetadata(String path, SparkContext sc, String expectedClassName) {
        return this.loadMetadata(path, SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate(), expectedClassName);
    }

    public DefaultParamsReader.Metadata loadMetadata(String path, SparkSession spark, String expectedClassName) {
        String metadataPath = new Path(path, "metadata").toString();
        String metadataStr = ReadWriteUtils$.MODULE$.loadText(metadataPath, spark);
        return this.parseMetadata(metadataStr, expectedClassName);
    }

    public DefaultParamsReader.Metadata loadMetadata(String path, SparkSession spark) {
        return this.loadMetadata(path, spark, "");
    }

    public String loadMetadata$default$3() {
        return "";
    }

    public DefaultParamsReader.Metadata parseMetadata(String metadataStr, String expectedClassName) {
        JValue metadata = JsonMethods$.MODULE$.parse((Object)metadataStr, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
        DefaultFormats$ format = DefaultFormats$.MODULE$;
        String className = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "class")), (Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        String uid = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "uid")), (Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        long timestamp = BoxesRunTime.unboxToLong((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "timestamp")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Long()));
        String sparkVersion = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "sparkVersion")), (Formats)format, ManifestFactory$.MODULE$.classType(String.class));
        JValue defaultParams = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "defaultParamMap");
        JValue params = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(metadata), "paramMap");
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(expectedClassName))) {
            String string = className;
            String string2 = expectedClassName;
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Error loading metadata: Expected class name " + expectedClassName + " but found class name " + className);
        }
        return new DefaultParamsReader.Metadata(className, uid, timestamp, sparkVersion, params, defaultParams, metadata, metadataStr);
    }

    public String parseMetadata$default$2() {
        return "";
    }

    public <T> T loadParamsInstance(String path, SparkContext sc) {
        return this.loadParamsInstance(path, SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate());
    }

    public <T> T loadParamsInstance(String path, SparkSession spark) {
        return this.loadParamsInstanceReader(path, spark).load(path);
    }

    public <T> MLReader<T> loadParamsInstanceReader(String path, SparkContext sc) {
        return this.loadParamsInstanceReader(path, SparkSession$.MODULE$.builder().sparkContext(sc).getOrCreate());
    }

    public <T> MLReader<T> loadParamsInstanceReader(String path, SparkSession spark) {
        DefaultParamsReader.Metadata metadata = this.loadMetadata(path, spark);
        Class cls = Utils$.MODULE$.classForName(metadata.className(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        return (MLReader)cls.getMethod("read", new Class[0]).invoke(null, new Object[0]);
    }

    private DefaultParamsReader$() {
    }
}

