/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.connect.proto.Read;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connect.ConnectConversions$;
import org.apache.spark.sql.connect.Dataset;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001\u0002\u000e\u001c\u0005\u0019B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0007c\u0001!\t!\b\u001a\t\u000fU\u0002!\u0019!C\u0005m!1!\u000b\u0001Q\u0001\n]BQa\u0015\u0001\u0005\u0002QCQA\u0019\u0001\u0005\u0002\rDQA\u0019\u0001\u0005B-DQA\u001c\u0001\u0005\u0002=DQ\u0001\u001e\u0001\u0005\u0002UDQ\u0001\u001e\u0001\u0005BuD\u0001\"!\u0004\u0001\t\u0003i\u0012q\u0002\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003kAq!a\u000f\u0001\t\u0003\ti\u0004C\u0004\u0002D\u0001!\t&!\u0012\t\r9\u0004A\u0011IA*\u0011\u0019q\u0007\u0001\"\u0011\u0002`!1a\u000e\u0001C!\u0003WBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002~\u0001!\t%a \t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\tY\n\u0001C!\u0003;\u0013\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005qi\u0012aB2p]:,7\r\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u000f\u0002\u0013M$(/Z1nS:<\u0017B\u0001\u000e*\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tqs&D\u0001\u001c\u0013\t\u00014D\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"A\f\u0001\t\u000b1\u0012\u0001\u0019A\u0017\u0002\u001bM|WO]2f\u0005VLG\u000eZ3s+\u00059\u0004C\u0001\u001dP\u001d\tIDJ\u0004\u0002;\u0013:\u00111H\u0012\b\u0003y\u0015s!!\u0010#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!&\u0003\u0019a$o\\8u}%\tA%\u0003\u0002#G%\u0011\u0001%I\u0005\u00039}I!a\u0012%\u0002\u000bA\u0014x\u000e^8\u000b\u0005qy\u0012B\u0001&L\u0003\u0011\u0011V-\u00193\u000b\u0005\u001dC\u0015BA'O\u0003)!\u0015\r^1T_V\u00148-\u001a\u0006\u0003\u0015.K!\u0001U)\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011QJT\u0001\u000fg>,(oY3Ck&dG-\u001a:!\u0003\u00191wN]7biR\u0011QKV\u0007\u0002\u0001!)q+\u0002a\u00011\u000611o\\;sG\u0016\u0004\"!W0\u000f\u0005ik\u0006CA \\\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y[\u0016AB:dQ\u0016l\u0017\r\u0006\u0002VI\")!M\u0002a\u0001KB\u0011a-[\u0007\u0002O*\u0011\u0001.H\u0001\u0006if\u0004Xm]\u0005\u0003U\u001e\u0014!b\u0015;sk\u000e$H+\u001f9f)\t)F\u000eC\u0003n\u000f\u0001\u0007\u0001,\u0001\u0007tG\",W.Y*ue&tw-\u0001\u0004paRLwN\u001c\u000b\u0004+B\u0014\b\"B9\t\u0001\u0004A\u0016aA6fs\")1\u000f\u0003a\u00011\u0006)a/\u00197vK\u00069q\u000e\u001d;j_:\u001cHCA+w\u0011\u0015!\u0018\u00021\u0001x!\u0011A8\u0010\u0017-\u000e\u0003eT!A_.\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002}s\n\u0019Q*\u00199\u0015\u0005Us\b\"\u0002;\u000b\u0001\u0004y\bCBA\u0001\u0003\u0017A\u0006,\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006L1\u0001`A\u0002\u0003\u0011q\u0017-\\3\u0015\u0007U\u000b\t\u0002\u0003\u0004\u0002\u0014-\u0001\r\u0001W\u0001\u000bg>,(oY3OC6,\u0007fA\u0006\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e}\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t#a\u0007\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\u0002\t1|\u0017\r\u001a\u000b\u0003\u0003O\u0001B!!\u000b\u000209\u0019a&a\u000b\n\u0007\u000552$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\f\u001c)\u0011\t9#a\u000e\t\r\u0005eR\u00021\u0001Y\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bQ\f'\r\\3\u0015\t\u0005\u001d\u0012q\b\u0005\u0007\u0003\u0003r\u0001\u0019\u0001-\u0002\u0013Q\f'\r\\3OC6,\u0017aF1tg\u0016\u0014HOT8Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b)\u0011\t9%a\u0014\u0011\t\u0005%\u00131J\u0007\u00027&\u0019\u0011QJ.\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003#z\u0001\u0019\u0001-\u0002\u0013=\u0004XM]1uS>tG#B+\u0002V\u0005]\u0003\"B9\u0011\u0001\u0004A\u0006BB:\u0011\u0001\u0004\tI\u0006\u0005\u0003\u0002J\u0005m\u0013bAA/7\n9!i\\8mK\u0006tG#B+\u0002b\u0005\r\u0004\"B9\u0012\u0001\u0004A\u0006BB:\u0012\u0001\u0004\t)\u0007\u0005\u0003\u0002J\u0005\u001d\u0014bAA57\n!Aj\u001c8h)\u0015)\u0016QNA8\u0011\u0015\t(\u00031\u0001Y\u0011\u0019\u0019(\u00031\u0001\u0002rA!\u0011\u0011JA:\u0013\r\t)h\u0017\u0002\u0007\t>,(\r\\3\u0002\t)\u001cxN\u001c\u000b\u0005\u0003O\tY\b\u0003\u0004\u0002:M\u0001\r\u0001W\u0001\u0004GN4H\u0003BA\u0014\u0003\u0003Ca!!\u000f\u0015\u0001\u0004A\u0016a\u0001=nYR!\u0011qEAD\u0011\u0019\tI$\u0006a\u00011\u0006\u0019qN]2\u0015\t\u0005\u001d\u0012Q\u0012\u0005\u0007\u0003s1\u0002\u0019\u0001-\u0002\u000fA\f'/];fiR!\u0011qEAJ\u0011\u0019\tId\u0006a\u00011\u0006!A/\u001a=u)\u0011\t9#!'\t\r\u0005e\u0002\u00041\u0001Y\u0003!!X\r\u001f;GS2,G\u0003BAP\u0003K\u0003BALAQ1&\u0019\u00111U\u000e\u0003\u000f\u0011\u000bG/Y:fi\"1\u0011\u0011H\rA\u0002aC3\u0001AAU!\u0011\tI\"a+\n\t\u00055\u00161\u0004\u0002\t\u000bZ|GN^5oO\u0002")
public final class DataStreamReader
extends org.apache.spark.sql.streaming.DataStreamReader {
    private final SparkSession sparkSession;
    private final Read.DataSource.Builder sourceBuilder;

    private Read.DataSource.Builder sourceBuilder() {
        return this.sourceBuilder;
    }

    @Override
    public DataStreamReader format(String source) {
        this.sourceBuilder().setFormat(source);
        return this;
    }

    @Override
    public DataStreamReader schema(StructType schema) {
        Object object = schema != null ? this.sourceBuilder().setSchema(schema.json()) : BoxedUnit.UNIT;
        return this;
    }

    @Override
    public DataStreamReader schema(String schemaString) {
        this.sourceBuilder().setSchema(schemaString);
        return this;
    }

    @Override
    public DataStreamReader option(String key, String value) {
        this.sourceBuilder().putOptions(key, value);
        return this;
    }

    @Override
    public DataStreamReader options(Map<String, String> options) {
        return this.options(CollectionConverters$.MODULE$.MapHasAsJava(options).asJava());
    }

    @Override
    public DataStreamReader options(java.util.Map<String, String> options) {
        this.sourceBuilder().putAllOptions(options);
        return this;
    }

    @Experimental
    public DataStreamReader name(String sourceName) {
        this.validateSourceName(sourceName);
        this.sourceBuilder().setSourceName(sourceName);
        return this;
    }

    public Dataset<Row> load() {
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable)relationBuilder -> {
            DataStreamReader.$anonfun$load$1(this, relationBuilder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> load(String path) {
        this.sourceBuilder().clearPaths();
        this.sourceBuilder().addPaths(path);
        return this.load();
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable)builder -> {
            DataStreamReader.$anonfun$table$2(this, tableName, builder);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void assertNoSpecifiedSchema(String operation) {
        if (this.sourceBuilder().hasSchema()) {
            throw DataTypeErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    @Override
    public DataStreamReader option(String key, boolean value) {
        return (DataStreamReader)super.option(key, value);
    }

    @Override
    public DataStreamReader option(String key, long value) {
        return (DataStreamReader)super.option(key, value);
    }

    @Override
    public DataStreamReader option(String key, double value) {
        return (DataStreamReader)super.option(key, value);
    }

    public Dataset<Row> json(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.json(path));
    }

    public Dataset<Row> csv(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.csv(path));
    }

    public Dataset<Row> xml(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.xml(path));
    }

    public Dataset<Row> orc(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.orc(path));
    }

    public Dataset<Row> parquet(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.parquet(path));
    }

    public Dataset<Row> text(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.text(path));
    }

    public Dataset<String> textFile(String path) {
        return ConnectConversions$.MODULE$.castToImpl(super.textFile(path));
    }

    public static final /* synthetic */ void $anonfun$load$1(DataStreamReader $this, Relation.Builder relationBuilder) {
        relationBuilder.getReadBuilder().setIsStreaming(true).setDataSource($this.sourceBuilder().build());
    }

    public static final /* synthetic */ void $anonfun$table$2(DataStreamReader $this, String tableName$1, Relation.Builder builder) {
        builder.getReadBuilder().setIsStreaming(true).getNamedTableBuilder().setUnparsedIdentifier(tableName$1).putAllOptions($this.sourceBuilder().getOptionsMap());
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.sourceBuilder = Read.DataSource.newBuilder();
    }
}

