/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;

public final class StructuredSessionization$ {
    public static final StructuredSessionization$ MODULE$ = new StructuredSessionization$();

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StructuredSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[1]));
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        Dataset events = lines.selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"explode(split(value, ' ')) AS sessionId", "timestamp AS eventTime"}));
        Dataset sessionUpdates = events.groupBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.session_window((Column)spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"eventTime"}))).$((Seq)Nil$.MODULE$), "10 seconds").as((Symbol)SymbolLiteral.bootstrap("apply", "session")), spark.implicits().StringToColumn(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId"}))).$((Seq)Nil$.MODULE$)})).agg(functions$.MODULE$.count("*").as("numEvents"), (Seq)Nil$.MODULE$).selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId", "CAST(session.start AS LONG)", "CAST(session.end AS LONG)", "CAST(session.end AS LONG) - CAST(session.start AS LONG) AS durationMs", "numEvents"}));
        StreamingQuery query = sessionUpdates.writeStream().outputMode("update").format("console").start();
        query.awaitTermination();
    }

    private StructuredSessionization$() {
    }
}

