/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.util.Collection;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.scostore.CollectionStore;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class CollectionMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        return Collection.class;
    }

    @Override
    public void insertPostProcessing(ObjectProvider ownerOP) {
    }

    @Override
    public void postInsert(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getCollection().elementIsPersistent()) {
                Object[] collElements;
                for (Object elem : collElements = value.toArray()) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, ownerOP, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerOP, null);
            return;
        }
        Object[] collElements = value.toArray();
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            for (int i = 0; i < collElements.length; ++i) {
                if (ec.getApiAdapter().isDetached(collElements[i]) || ec.getApiAdapter().isPersistent(collElements[i])) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), collElements[i]);
            }
        } else if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{this.mmd.getFullFieldName()}));
        }
        boolean needsAttaching = false;
        for (int i = 0; i < collElements.length; ++i) {
            if (!ownerOP.getExecutionContext().getApiAdapter().isDetached(collElements[i])) continue;
            needsAttaching = true;
            break;
        }
        if (needsAttaching) {
            SCO collWrapper = this.replaceFieldWithWrapper(ownerOP, null);
            if (value.size() > 0) {
                collWrapper.attachCopy((Object)value);
                ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)collWrapper).getBackingStore(), ownerOP);
            }
        } else if (value.size() > 0) {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, value.getClass())).addAll(ownerOP, value, 0);
            this.replaceFieldWithWrapper(ownerOP, value);
        } else if (this.mmd.getRelationType(ownerOP.getExecutionContext().getClassLoaderResolver()) == RelationType.MANY_TO_MANY_BI) {
            this.replaceFieldWithWrapper(ownerOP, null);
        } else {
            this.replaceFieldWithWrapper(ownerOP, value);
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null && this.mmd.getCollection().elementIsPersistent()) {
                Object[] collElements;
                for (Object elem : collElements = value.toArray()) {
                    ObjectProvider elemOP;
                    if (elem == null || (elemOP = ec.findObjectProvider(elem)) != null && ec.getApiAdapter().getExecutionContext(elem) != null) continue;
                    elemOP = ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(ec, elem, false, ownerOP, this.mmd.getAbsoluteFieldNumber());
                }
            }
            return;
        }
        if (value == null) {
            ((CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, null)).clear(ownerOP);
            this.replaceFieldWithWrapper(ownerOP, null);
            return;
        }
        if (value instanceof BackedSCO) {
            ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerOP);
            return;
        }
        if (this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            return;
        }
        CollectionStore backingStore = (CollectionStore)this.storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        backingStore.update(ownerOP, value);
        this.replaceFieldWithWrapper(ownerOP, value);
    }

    @Override
    public void preDelete(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerOP.isLoaded(this.getAbsoluteFieldNumber());
        Collection value = (Collection)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        boolean dependent = this.mmd.getCollection().isDependentElement();
        if (this.mmd.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        boolean hasJoin = this.mmd.getJoinMetaData() != null;
        boolean hasFK = false;
        if (!hasJoin) {
            if (this.mmd.getElementMetaData() != null && this.mmd.getElementMetaData().getForeignKeyMetaData() != null) {
                hasFK = true;
            } else if (this.mmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            AbstractMemberMetaData[] relatedMmds = this.mmd.getRelatedMemberMetaData(ownerOP.getExecutionContext().getClassLoaderResolver());
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
        }
        if (ownerOP.getExecutionContext().getStringProperty("datanucleus.deletionPolicy").equals("JDO2")) {
            hasFK = false;
        }
        if (ownerOP.getExecutionContext().getManageRelations()) {
            ownerOP.getExecutionContext().getRelationshipManager(ownerOP).relationChange(this.getAbsoluteFieldNumber(), (Object)value, null);
        }
        if (dependent || hasJoin || !hasFK) {
            if (!(value instanceof SCO)) {
                value = (Collection)SCOUtils.wrapSCOField((ObjectProvider)ownerOP, (int)this.getAbsoluteFieldNumber(), (Object)value, (boolean)true);
            }
            value.clear();
            ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerOP);
        }
    }
}

