/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.ByteArrayBodyHandler;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpClientReadableByteChannel;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.HttpResponseAdapter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;

class SendAsyncUtils {
    private SendAsyncUtils() {
    }

    static CompletableFuture<HttpResponse<Reader>> reader(HttpRequest request, HttpClient client) {
        return SendAsyncUtils.inputStream(request, client).thenApply(res -> new HttpResponseAdapter<InputStreamReader>((HttpResponse<?>)res, new InputStreamReader((InputStream)res.body(), StandardCharsets.UTF_8)));
    }

    static CompletableFuture<HttpResponse<InputStream>> inputStream(HttpRequest request, HttpClient client) {
        HttpClientReadableByteChannel byteChannel = new HttpClientReadableByteChannel();
        CompletableFuture<HttpResponse<AsyncBody>> futureResponse = client.consumeBytes(request, byteChannel);
        return futureResponse.thenApply(res -> {
            byteChannel.onResponse((HttpResponse<AsyncBody>)res);
            return new HttpResponseAdapter<InputStream>((HttpResponse<?>)res, Channels.newInputStream(byteChannel));
        });
    }

    static CompletableFuture<HttpResponse<byte[]>> bytes(HttpRequest request, HttpClient client) {
        ByteArrayBodyHandler byteArrayBodyHandler = new ByteArrayBodyHandler();
        CompletableFuture<HttpResponse<AsyncBody>> futureResponse = client.consumeBytes(request, byteArrayBodyHandler);
        return futureResponse.thenCompose(res -> {
            byteArrayBodyHandler.onResponse((HttpResponse<AsyncBody>)res);
            return byteArrayBodyHandler.getResult().thenApply(b -> new HttpResponseAdapter<byte[]>((HttpResponse<?>)res, (byte[])b));
        });
    }

    static CompletableFuture<HttpResponse<String>> string(HttpRequest request, HttpClient client) {
        return SendAsyncUtils.bytes(request, client).thenApply(res -> new HttpResponseAdapter<String>((HttpResponse<?>)res, new String((byte[])res.body(), StandardCharsets.UTF_8)));
    }
}

