/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Util;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class OptionalSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.util.Optional")) {
            kryo.addDefaultSerializer(Optional.class, new OptionalSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalInt")) {
            kryo.addDefaultSerializer(OptionalInt.class, new OptionalIntSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalLong")) {
            kryo.addDefaultSerializer(OptionalLong.class, new OptionalLongSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalDouble")) {
            kryo.addDefaultSerializer(OptionalDouble.class, new OptionalDoubleSerializer());
        }
    }

    private static class OptionalDoubleSerializer
    extends Serializer<OptionalDouble> {
        private OptionalDoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalDouble object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeDouble(object.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(Kryo kryo, Input input, Class<OptionalDouble> type) {
            boolean present = input.readBoolean();
            return present ? OptionalDouble.of(input.readDouble()) : OptionalDouble.empty();
        }
    }

    private static class OptionalLongSerializer
    extends Serializer<OptionalLong> {
        private OptionalLongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalLong object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeLong(object.getAsLong());
            }
        }

        @Override
        public OptionalLong read(Kryo kryo, Input input, Class<OptionalLong> type) {
            boolean present = input.readBoolean();
            return present ? OptionalLong.of(input.readLong()) : OptionalLong.empty();
        }
    }

    private static class OptionalIntSerializer
    extends Serializer<OptionalInt> {
        private OptionalIntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalInt object) {
            output.writeBoolean(object.isPresent());
            if (object.isPresent()) {
                output.writeInt(object.getAsInt());
            }
        }

        @Override
        public OptionalInt read(Kryo kryo, Input input, Class<OptionalInt> type) {
            boolean present = input.readBoolean();
            return present ? OptionalInt.of(input.readInt()) : OptionalInt.empty();
        }
    }

    private static class OptionalSerializer
    extends Serializer<Optional> {
        private OptionalSerializer() {
            this.setAcceptsNull(false);
        }

        @Override
        public void write(Kryo kryo, Output output, Optional object) {
            Object nullable = object.isPresent() ? object.get() : null;
            kryo.writeClassAndObject(output, nullable);
        }

        @Override
        public Optional read(Kryo kryo, Input input, Class<Optional> type) {
            return Optional.ofNullable(kryo.readClassAndObject(input));
        }

        @Override
        public Optional copy(Kryo kryo, Optional original) {
            if (original.isPresent()) {
                return Optional.of(kryo.copy(original.get()));
            }
            return original;
        }
    }
}

