/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.protocol.Encoders;
import org.roaringbitmap.RoaringBitmap;

public class MergedBlockMeta {
    private final int numChunks;
    private final ManagedBuffer chunksBitmapBuffer;

    public MergedBlockMeta(int numChunks, ManagedBuffer chunksBitmapBuffer) {
        this.numChunks = numChunks;
        this.chunksBitmapBuffer = Objects.requireNonNull(chunksBitmapBuffer);
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public ManagedBuffer getChunksBitmapBuffer() {
        return this.chunksBitmapBuffer;
    }

    public RoaringBitmap[] readChunkBitmaps() throws IOException {
        ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)this.chunksBitmapBuffer.nioByteBuffer());
        ArrayList<RoaringBitmap> bitmaps = new ArrayList<RoaringBitmap>();
        while (buf.isReadable()) {
            bitmaps.add(Encoders.Bitmaps.decode((ByteBuf)buf));
        }
        assert (bitmaps.size() == this.numChunks);
        return bitmaps.toArray(new RoaringBitmap[0]);
    }
}

