/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class OfflineStateRepartitionUtils$ {
    public static final OfflineStateRepartitionUtils$ MODULE$ = new OfflineStateRepartitionUtils$();

    public boolean isRepartitionBatch(long batchId, OffsetSeqLog offsetLog) {
        Predef$.MODULE$.require(batchId >= 0L, (Function0 & Serializable)() -> "Batch ID must be non-negative");
        long l = batchId;
        if (0L == l) {
            return false;
        }
        Option batchOpt = offsetLog.get(batchId);
        Predef$.MODULE$.require(batchOpt.isDefined(), (Function0 & Serializable)() -> "Batch " + batchId + " not found in offset log");
        OffsetSeqBase batch = (OffsetSeqBase)batchOpt.get();
        long prevBatchId = batchId - 1L;
        Option prevBatchOpt = offsetLog.get(prevBatchId);
        Predef$.MODULE$.require(prevBatchOpt.isDefined(), (Function0 & Serializable)() -> "Previous batch " + prevBatchId + " not found in offset log");
        OffsetSeqBase previousBatch = (OffsetSeqBase)prevBatchOpt.get();
        Predef$.MODULE$.require(batch.metadataOpt().isDefined(), (Function0 & Serializable)() -> "Batch " + batchId + " metadata not found");
        int shufflePartitions = BoxesRunTime.unboxToInt((Object)this.getShufflePartitions((OffsetSeqMetadataBase)batch.metadataOpt().get()).get());
        Predef$.MODULE$.require(previousBatch.metadataOpt().isDefined(), (Function0 & Serializable)() -> "Previous batch " + prevBatchId + " metadata not found");
        int previousShufflePartitions = BoxesRunTime.unboxToInt((Object)this.getShufflePartitions((OffsetSeqMetadataBase)previousBatch.metadataOpt().get()).get());
        return previousShufflePartitions != shufflePartitions;
    }

    public Option<Object> getShufflePartitions(OffsetSeqMetadataBase metadata) {
        return metadata.conf().get((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1))));
    }

    private OfflineStateRepartitionUtils$() {
    }
}

