/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataUtils;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataUtils$;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001E\t\u0001A!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B*\u0001\t\u0003!\u0006b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u00079\u0002\u0001\u000b\u0011\u0002!\t\u000fu\u0003!\u0019!C\u0001=\"1q\f\u0001Q\u0001\nACq\u0001\u0019\u0001C\u0002\u0013%1\f\u0003\u0004b\u0001\u0001\u0006I\u0001\u0011\u0005\tE\u0002A)\u0019!C\u0005G\")!\u000e\u0001C!W\")q\u000e\u0001C\u0005a\")Q\u000f\u0001C\u0005m\")q\u000f\u0001C!q\nir\n]3sCR|'o\u0015;bi\u0016lU\r^1eCR\fgK\r*fC\u0012,'O\u0003\u0002\u0013'\u0005)1\u000f^1uK*\u0011A#F\u0001\ngR\u0014X-Y7j]\u001eT!AF\f\u0002\u0013\u0015DXmY;uS>t'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001\u000b\u001f\u000f\u0005%RdB\u0001\u0016:\u001d\tY\u0003H\u0004\u0002-o9\u0011QF\u000e\b\u0003]Ur!a\f\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0005Iz\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012BA\u001e\u0012\u0003iy\u0005/\u001a:bi>\u00148\u000b^1uK6+G/\u00193bi\u0006,F/\u001b7t\u0013\tidHA\u000ePa\u0016\u0014\u0018\r^8s'R\fG/Z'fi\u0006$\u0017\r^1SK\u0006$WM\u001d\u0006\u0003wE\t1c\u001d;bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e)bi\"\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0005\u0019\u001c(BA#\u001c\u0003\u0019A\u0017\rZ8pa&\u0011qI\u0011\u0002\u0005!\u0006$\b.\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"AS'\u000e\u0003-S!\u0001\u0014#\u0002\t\r|gNZ\u0005\u0003\u001d.\u0013QbQ8oM&<WO]1uS>t\u0017a\u00022bi\u000eD\u0017\n\u001a\t\u0003EEK!AU\u0012\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU;\u0006,\u0017\t\u0003-\u0002i\u0011!\u0005\u0005\u0006\u007f\u0011\u0001\r\u0001\u0011\u0005\u0006\u0011\u0012\u0001\r!\u0013\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\u0012E\u0006\u001cXm\u00115fG.\u0004x.\u001b8u\t&\u0014X#\u0001!\u0002%\t\f7/Z\"iK\u000e\\\u0007o\\5oi\u0012K'\u000fI\u0001\u0010Y\u0006\u001cH/\u0011<bS2|eMZ:fiV\t\u0001+\u0001\tmCN$\u0018I^1jY>3gm]3uA\u0005yQ.\u001a;bI\u0006$\u0018\rR5s!\u0006$\b.\u0001\tnKR\fG-\u0019;b\t&\u0014\b+\u0019;iA\u0005\u0011a-\\\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qmE\u0001\u000eG\",7m\u001b9pS:$\u0018N\\4\n\u0005%4'!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\bm\u0016\u00148/[8o+\u0005a\u0007C\u0001\u0012n\u0013\tq7EA\u0002J]R\f1\u0002\\5ti>3gm]3ugR\u0011\u0011\u000f\u001e\t\u0004EI\u0004\u0016BA:$\u0005\u0015\t%O]1z\u0011\u0015QV\u00021\u0001A\u0003ma\u0017n\u001d;Pa\u0016\u0014\u0018\r^8s\u001b\u0016$\u0018\rZ1uC\n\u000bGo\u00195fgR\t\u0011/\u0001\u0003sK\u0006$G#A=\u0011\u0007\tRH0\u0003\u0002|G\t1q\n\u001d;j_:\u0004\"AV?\n\u0005y\f\"!F(qKJ\fGo\u001c:Ti\u0006$X-T3uC\u0012\fG/\u0019")
public class OperatorStateMetadataV2Reader
implements OperatorStateMetadataUtils.OperatorStateMetadataReader {
    private CheckpointFileManager fm;
    private final Path stateCheckpointPath;
    private final Configuration hadoopConf;
    private final long batchId;
    private final Path baseCheckpointDir;
    private final long lastAvailOffset;
    private final Path metadataDirPath;
    private volatile boolean bitmap$0;

    public Path baseCheckpointDir() {
        return this.baseCheckpointDir;
    }

    public long lastAvailOffset() {
        return this.lastAvailOffset;
    }

    private Path metadataDirPath() {
        return this.metadataDirPath;
    }

    private CheckpointFileManager fm$lzycompute() {
        OperatorStateMetadataV2Reader operatorStateMetadataV2Reader = this;
        synchronized (operatorStateMetadataV2Reader) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(this.metadataDirPath(), this.hadoopConf);
                this.bitmap$0 = true;
            }
        }
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if (!this.bitmap$0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    @Override
    public int version() {
        return 2;
    }

    private long[] listOffsets(Path baseCheckpointDir) {
        Path offsetLog = new Path(baseCheckpointDir, StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS());
        CheckpointFileManager fm = CheckpointFileManager$.MODULE$.create(offsetLog, this.hadoopConf);
        if (!fm.exists(offsetLog)) {
            return (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fm.list(offsetLog)), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OperatorStateMetadataV2Reader.$anonfun$listOffsets$1(f)))), (Function1 & Serializable)f -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(f.getPath().getName()))).toOption(), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    private long[] listOperatorMetadataBatches() {
        if (!this.fm().exists(this.metadataDirPath())) {
            return (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long());
        }
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(this.metadataDirPath())), (Function1 & Serializable)f -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(f.getPath().getName()))).toOption(), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    @Override
    public Option<OperatorStateMetadata> read() {
        long[] batches = this.listOperatorMetadataBatches();
        Option lastBatchId = ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(batches), (Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 <= $this.batchId)));
        if (lastBatchId.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.failedToReadOperatorMetadata(this.stateCheckpointPath.toString(), this.batchId);
        }
        Path metadataFilePath = OperatorStateMetadataV2$.MODULE$.metadataFilePath(this.stateCheckpointPath, BoxesRunTime.unboxToLong((Object)lastBatchId.get()));
        FSDataInputStream inputStream = this.fm().open(metadataFilePath);
        return OperatorStateMetadataUtils$.MODULE$.readMetadata(inputStream, this.version());
    }

    public static final /* synthetic */ boolean $anonfun$listOffsets$1(FileStatus f) {
        return !f.getPath().getName().startsWith(".");
    }

    public OperatorStateMetadataV2Reader(Path stateCheckpointPath, Configuration hadoopConf, long batchId) {
        this.stateCheckpointPath = stateCheckpointPath;
        this.hadoopConf = hadoopConf;
        this.batchId = batchId;
        this.baseCheckpointDir = stateCheckpointPath.getParent().getParent();
        this.lastAvailOffset = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps(this.listOffsets(this.baseCheckpointDir()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        if (batchId > this.lastAvailOffset()) {
            throw StateDataSourceErrors$.MODULE$.failedToReadOperatorMetadata(this.baseCheckpointDir().toString(), batchId);
        }
        this.metadataDirPath = OperatorStateMetadataV2$.MODULE$.metadataDirPath(stateCheckpointPath);
        this.fm().mkdirs(this.metadataDirPath().getParent());
    }
}

