/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcArrayColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcAtomicColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcMapColumnVector;
import org.apache.spark.sql.execution.datasources.orc.OrcStructColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class OrcColumnVectorUtils {
    OrcColumnVectorUtils() {
    }

    static OrcColumnVector toOrcColumnVector(DataType type, ColumnVector vector) {
        if (vector instanceof LongColumnVector || vector instanceof DoubleColumnVector || vector instanceof BytesColumnVector || vector instanceof DecimalColumnVector || vector instanceof TimestampColumnVector) {
            return new OrcAtomicColumnVector(type, vector);
        }
        if (vector instanceof StructColumnVector) {
            StructColumnVector structVector = (StructColumnVector)vector;
            OrcColumnVector[] fields = new OrcColumnVector[structVector.fields.length];
            int ordinal = 0;
            for (StructField f : ((StructType)type).fields()) {
                fields[ordinal] = OrcColumnVectorUtils.toOrcColumnVector(f.dataType(), structVector.fields[ordinal]);
                ++ordinal;
            }
            return new OrcStructColumnVector(type, vector, fields);
        }
        if (vector instanceof ListColumnVector) {
            ListColumnVector listVector = (ListColumnVector)vector;
            OrcColumnVector dataVector = OrcColumnVectorUtils.toOrcColumnVector(((ArrayType)type).elementType(), listVector.child);
            return new OrcArrayColumnVector(type, vector, dataVector);
        }
        if (vector instanceof MapColumnVector) {
            MapColumnVector mapVector = (MapColumnVector)vector;
            MapType mapType = (MapType)type;
            OrcColumnVector keysVector = OrcColumnVectorUtils.toOrcColumnVector(mapType.keyType(), mapVector.keys);
            OrcColumnVector valuesVector = OrcColumnVectorUtils.toOrcColumnVector(mapType.valueType(), mapVector.values);
            return new OrcMapColumnVector(type, vector, keysVector, valuesVector);
        }
        throw new IllegalArgumentException(String.format("OrcColumnVectorUtils.toOrcColumnVector should not take %s as type and %s as vector", type, vector));
    }
}

