/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.ann.FeedForwardTopology;
import org.apache.spark.ml.ann.FeedForwardTopology$;
import org.apache.spark.ml.ann.FeedForwardTrainer;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier$;
import org.apache.spark.ml.classification.MultilayerPerceptronParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasBlockSize;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001\u0002\u000f\u001e\u0001!B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t1\u0002\u0011\t\u0011)A\u0005\u0005\")!\f\u0001C\u00017\")!\f\u0001C\u0001?\")\u0011\r\u0001C\u0001E\")a\u000e\u0001C\u0001_\")!\u000f\u0001C\u0001g\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0003\u0001C!\u0003OA\u0001\"a\u000f\u0001\t\u0003\n\u0013Q\b\u0005\b\u0003O\u0002A\u0011KA5\u0011\u001d\t9\b\u0001C\u0005\u0003s:q!a%\u001e\u0011\u0003\t)J\u0002\u0004\u001d;!\u0005\u0011q\u0013\u0005\u00075J!\t!!.\t\u0015\u0005]&C1A\u0005\u0002u\tI\f\u0003\u0005\u0002FJ\u0001\u000b\u0011BA^\u0011)\t9M\u0005b\u0001\n\u0003i\u0012\u0011\u0018\u0005\t\u0003\u0013\u0014\u0002\u0015!\u0003\u0002<\"Q\u00111\u001a\nC\u0002\u0013\u0005Q$!4\t\u0011\u0005E'\u0003)A\u0005\u0003\u001fDq!a5\u0013\t\u0003\n)\u000eC\u0005\u0002^J\t\t\u0011\"\u0003\u0002`\nqR*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aLWM\u001d\u0006\u0003=}\tab\u00197bgNLg-[2bi&|gN\u0003\u0002!C\u0005\u0011Q\u000e\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011\u0003\u0002\u0001*oi\u0002RAK\u0016.gQj\u0011!H\u0005\u0003Yu\u0011q\u0003\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017.\u001a:\u0011\u00059\nT\"A\u0018\u000b\u0005Az\u0012A\u00027j]\u0006dw-\u0003\u00023_\t1a+Z2u_J\u0004\"A\u000b\u0001\u0011\u0005)*\u0014B\u0001\u001c\u001e\u0005\u001djU\u000f\u001c;jY\u0006LXM\u001d)fe\u000e,\u0007\u000f\u001e:p]\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005)B\u0014BA\u001d\u001e\u0005iiU\u000f\u001c;jY\u0006LXM\u001d)fe\u000e,\u0007\u000f\u001e:p]B\u000b'/Y7t!\tYd(D\u0001=\u0015\tit$\u0001\u0003vi&d\u0017BA =\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005\u0011\u0005CA\"M\u001d\t!%\n\u0005\u0002F\u00116\taI\u0003\u0002HO\u00051AH]8pizR\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u000ba\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111\n\u0013\u0015\u0004\u0003A3\u0006CA)U\u001b\u0005\u0011&BA*\"\u0003)\tgN\\8uCRLwN\\\u0005\u0003+J\u0013QaU5oG\u0016\f\u0013aV\u0001\u0006c9*d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003!Z\u000ba\u0001P5oSRtDCA\u001a]\u0011\u0015\u00015\u00011\u0001CQ\ra\u0006K\u0016\u0015\u0004\u0007A3F#A\u001a)\u0007\u0011\u0001f+A\u0005tKRd\u0015-_3sgR\u00111\rZ\u0007\u0002\u0001!)Q-\u0002a\u0001M\u0006)a/\u00197vKB\u0019q\r\u001b6\u000e\u0003!K!!\u001b%\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001d\\\u0017B\u00017I\u0005\rIe\u000e\u001e\u0015\u0004\u000bA3\u0016\u0001D:fi\ncwnY6TSj,GCA2q\u0011\u0015)g\u00011\u0001kQ\r1\u0001KV\u0001\ng\u0016$8k\u001c7wKJ$\"a\u0019;\t\u000b\u0015<\u0001\u0019\u0001\")\u0007\u001d\u0001f/I\u0001x\u0003\u0015\u0011d\u0006\r\u00181\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003GjDQ!\u001a\u0005A\u0002)D3\u0001\u0003)W\u0003\u0019\u0019X\r\u001e+pYR\u00111M \u0005\u0006K&\u0001\ra \t\u0004O\u0006\u0005\u0011bAA\u0002\u0011\n1Ai\\;cY\u0016D3!\u0003)W\u0003\u001d\u0019X\r^*fK\u0012$2aYA\u0006\u0011\u0019)'\u00021\u0001\u0002\u000eA\u0019q-a\u0004\n\u0007\u0005E\u0001J\u0001\u0003M_:<\u0007f\u0001\u0006Q-\u0006\t2/\u001a;J]&$\u0018.\u00197XK&<\u0007\u000e^:\u0015\u0007\r\fI\u0002C\u0003f\u0017\u0001\u0007Q\u0006K\u0002\f!Z\f1b]3u'R,\u0007oU5{KR\u00191-!\t\t\u000b\u0015d\u0001\u0019A@)\u00071\u0001f/\u0001\u0003d_BLHcA\u001a\u0002*!9\u00111F\u0007A\u0002\u00055\u0012!B3yiJ\f\u0007\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005Mr$A\u0003qCJ\fW.\u0003\u0003\u00028\u0005E\"\u0001\u0003)be\u0006lW*\u00199)\u00075\u0001f+A\tfgRLW.\u0019;f\u001b>$W\r\\*ju\u0016$B!!\u0004\u0002@!9\u0011\u0011\t\bA\u0002\u0005\r\u0013a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u000b\n)\u0006\u0005\u0004\u0002H\u00055\u0013\u0011K\u0007\u0003\u0003\u0013R1!a\u0013\"\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u001f\nIEA\u0004ECR\f7/\u001a;\u0011\t\u0005M\u0013Q\u000b\u0007\u0001\t1\t9&a\u0010\u0002\u0002\u0003\u0005)\u0011AA-\u0005\ryF%M\t\u0005\u00037\n\t\u0007E\u0002h\u0003;J1!a\u0018I\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aZA2\u0013\r\t)\u0007\u0013\u0002\u0004\u0003:L\u0018!\u0002;sC&tGc\u0001\u001b\u0002l!9\u0011\u0011I\bA\u0002\u00055\u0004\u0007BA8\u0003g\u0002b!a\u0012\u0002N\u0005E\u0004\u0003BA*\u0003g\"A\"!\u001e\u0002l\u0005\u0005\t\u0011!B\u0001\u00033\u00121a\u0018\u00133\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\u000fQ\nY(a\"\u0002\f\"9\u0011\u0011\t\tA\u0002\u0005u\u0004\u0007BA@\u0003\u0007\u0003b!a\u0012\u0002N\u0005\u0005\u0005\u0003BA*\u0003\u0007#A\"!\"\u0002|\u0005\u0005\t\u0011!B\u0001\u00033\u00121a\u0018\u00134\u0011\u0019\tI\t\u0005a\u0001[\u00059q/Z5hQR\u001c\bbBAG!\u0001\u0007\u0011qR\u0001\u0011_\nTWm\u0019;jm\u0016D\u0015n\u001d;pef\u00042a\u001a5\u0000Q\r\u0001\u0001KV\u0001\u001f\u001bVdG/\u001b7bs\u0016\u0014\b+\u001a:dKB$(o\u001c8DY\u0006\u001c8/\u001b4jKJ\u0004\"A\u000b\n\u0014\u000fI\tI*a(\u0002&B\u0019q-a'\n\u0007\u0005u\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0005w\u0005\u00056'C\u0002\u0002$r\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\r\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0005%|'BAAX\u0003\u0011Q\u0017M^1\n\t\u0005M\u0016\u0011\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003+\u000bQ\u0001\u0014\"G\u000fN+\"!a/\u0011\t\u0005u\u00161Y\u0007\u0003\u0003\u007fSA!!1\u0002.\u0006!A.\u00198h\u0013\ri\u0015qX\u0001\u0007\u0019\n3ui\u0015\u0011\u0002\u0005\u001d#\u0015aA$EA\u0005\u00012/\u001e9q_J$X\rZ*pYZ,'o]\u000b\u0003\u0003\u001f\u0004Ba\u001a5\u0002<\u0006\t2/\u001e9q_J$X\rZ*pYZ,'o\u001d\u0011\u0002\t1|\u0017\r\u001a\u000b\u0004g\u0005]\u0007BBAm5\u0001\u0007!)\u0001\u0003qCRD\u0007f\u0001\u000eQm\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001d\t\u0005\u0003{\u000b\u0019/\u0003\u0003\u0002f\u0006}&AB(cU\u0016\u001cG\u000fK\u0002\u0013!ZD3!\u0005)w\u0001")
public class MultilayerPerceptronClassifier
extends ProbabilisticClassifier<Vector, MultilayerPerceptronClassifier, MultilayerPerceptronClassificationModel>
implements MultilayerPerceptronParams,
DefaultParamsWritable {
    private final String uid;
    private IntArrayParam layers;
    private Param<String> solver;
    private Param<Vector> initialWeights;
    private IntParam blockSize;
    private DoubleParam stepSize;
    private DoubleParam tol;
    private IntParam maxIter;
    private LongParam seed;

    public static MultilayerPerceptronClassifier load(String path) {
        return MultilayerPerceptronClassifier$.MODULE$.load(path);
    }

    public static MLReader<MultilayerPerceptronClassifier> read() {
        return MultilayerPerceptronClassifier$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int[] getLayers() {
        return MultilayerPerceptronParams.getLayers$(this);
    }

    @Override
    public final Vector getInitialWeights() {
        return MultilayerPerceptronParams.getInitialWeights$(this);
    }

    @Override
    public final int getBlockSize() {
        return HasBlockSize.getBlockSize$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final IntArrayParam layers() {
        return this.layers;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<Vector> initialWeights() {
        return this.initialWeights;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$layers_$eq(IntArrayParam x$1) {
        this.layers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$initialWeights_$eq(Param<Vector> x$1) {
        this.initialWeights = x$1;
    }

    @Override
    public final IntParam blockSize() {
        return this.blockSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasBlockSize$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public MultilayerPerceptronClassifier setLayers(int[] value) {
        return (MultilayerPerceptronClassifier)this.set(this.layers(), value);
    }

    public MultilayerPerceptronClassifier setBlockSize(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setSolver(String value) {
        return (MultilayerPerceptronClassifier)this.set(this.solver(), value);
    }

    public MultilayerPerceptronClassifier setMaxIter(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setTol(double value) {
        return (MultilayerPerceptronClassifier)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public MultilayerPerceptronClassifier setSeed(long value) {
        return (MultilayerPerceptronClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public MultilayerPerceptronClassifier setInitialWeights(Vector value) {
        return (MultilayerPerceptronClassifier)this.set(this.initialWeights(), value);
    }

    public MultilayerPerceptronClassifier setStepSize(double value) {
        return (MultilayerPerceptronClassifier)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public MultilayerPerceptronClassifier copy(ParamMap extra) {
        return (MultilayerPerceptronClassifier)this.defaultCopy(extra);
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        FeedForwardTopology topology = FeedForwardTopology$.MODULE$.multiLayerPerceptron(this.$(this.layers()), true);
        int expectedWeightSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topology.layers()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.weightSize()), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        long size = this.estimateMatadataSize();
        return size += Vectors$.MODULE$.getDenseSize((long)expectedWeightSize);
    }

    @Override
    public MultilayerPerceptronClassificationModel train(Dataset<?> dataset) {
        return (MultilayerPerceptronClassificationModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.layers(), this.maxIter(), this.tol(), this.blockSize(), this.solver(), this.stepSize(), this.seed(), this.thresholds()}));
            int[] myLayers = this.$(this.layers());
            int labels = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(myLayers)));
            instr.logNumClasses(labels);
            instr.logNumFeatures(BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(myLayers))));
            Dataset validated = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)labels))).as("_validated_label_"), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol())).as("_validated_features_")}));
            String encodedLabelCol = "_encoded" + this.$(this.labelCol());
            OneHotEncoderModel encodeModel = new OneHotEncoderModel(this.uid(), new int[]{labels}).setInputCols((String[])((Object[])new String[]{"_validated_label_"})).setOutputCols((String[])((Object[])new String[]{encodedLabelCol})).setDropLast(false);
            Dataset<Row> encodedDataset = encodeModel.transform(validated);
            RDD data = encodedDataset.select("_validated_features_", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{encodedLabelCol})).rdd().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
                    Object features = ((SeqOps)some.get()).apply(0);
                    Object encodedLabel = ((SeqOps)some.get()).apply(1);
                    if (features instanceof Vector) {
                        Vector vector = (Vector)features;
                        if (encodedLabel instanceof Vector) {
                            Vector vector2 = (Vector)encodedLabel;
                            return new Tuple2((Object)vector, (Object)vector2);
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            FeedForwardTopology topology = FeedForwardTopology$.MODULE$.multiLayerPerceptron(myLayers, true);
            FeedForwardTrainer trainer = new FeedForwardTrainer(topology, myLayers[0], BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(myLayers))));
            FeedForwardTrainer feedForwardTrainer = this.isDefined(this.initialWeights()) ? trainer.setWeights(this.$(this.initialWeights())) : trainer.setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed())));
            String string = this.$(this.solver());
            String string2 = MultilayerPerceptronClassifier$.MODULE$.LBFGS();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                v2 = trainer.LBFGSOptimizer().setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setNumIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())));
            } else {
                String string3 = this.$(this.solver());
                String string4 = MultilayerPerceptronClassifier$.MODULE$.GD();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    v2 = trainer.SGDOptimizer().setNumIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setStepSize(BoxesRunTime.unboxToDouble((Object)this.$(this.stepSize())));
                } else {
                    throw new IllegalArgumentException("The solver " + this.solver() + " is not supported by MultilayerPerceptronClassifier.");
                }
            }
            trainer.setStackSize(BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
            Tuple2<TopologyModel, double[]> tuple2 = trainer.train((RDD<Tuple2<Vector, Vector>>)data);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopologyModel mlpModel = (TopologyModel)tuple2._1();
            double[] objectiveHistory = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mlpModel, (Object)objectiveHistory);
            TopologyModel mlpModel2 = (TopologyModel)tuple22._1();
            double[] objectiveHistory2 = (double[])tuple22._2();
            return this.createModel(dataset, mlpModel2.weights(), objectiveHistory2);
        });
    }

    private MultilayerPerceptronClassificationModel createModel(Dataset<?> dataset, Vector weights, double[] objectiveHistory) {
        MultilayerPerceptronClassificationModel model = this.copyValues(new MultilayerPerceptronClassificationModel(this.uid(), weights), this.copyValues$default$2());
        model.createSummary(dataset, objectiveHistory);
        return model;
    }

    public MultilayerPerceptronClassifier(String uid) {
        this.uid = uid;
        HasSeed.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasStepSize.$init$(this);
        HasSolver.$init$(this);
        HasBlockSize.$init$(this);
        MultilayerPerceptronParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public MultilayerPerceptronClassifier() {
        this(Identifiable$.MODULE$.randomUID("mlpc"));
    }
}

