/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;

public final class RollingEventLogFilesWriter$ {
    public static final RollingEventLogFilesWriter$ MODULE$ = new RollingEventLogFilesWriter$();
    private static final String EVENT_LOG_DIR_NAME_PREFIX = "eventlog_v2_";
    private static final String EVENT_LOG_FILE_NAME_PREFIX = "events_";
    private static final String APPSTATUS_FILE_NAME_PREFIX = "appstatus_";

    public String EVENT_LOG_DIR_NAME_PREFIX() {
        return EVENT_LOG_DIR_NAME_PREFIX;
    }

    public String EVENT_LOG_FILE_NAME_PREFIX() {
        return EVENT_LOG_FILE_NAME_PREFIX;
    }

    public String APPSTATUS_FILE_NAME_PREFIX() {
        return APPSTATUS_FILE_NAME_PREFIX;
    }

    public Path getAppEventLogDirPath(URI logBaseDir, String appId, Option<String> appAttemptId) {
        return new Path(new Path(logBaseDir), this.EVENT_LOG_DIR_NAME_PREFIX() + EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId));
    }

    public Path getAppStatusFilePath(Path appLogDir, String appId, Option<String> appAttemptId, boolean inProgress) {
        String base = this.APPSTATUS_FILE_NAME_PREFIX() + EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId);
        String name = inProgress ? base + EventLogFileWriter$.MODULE$.IN_PROGRESS() : base;
        return new Path(appLogDir, name);
    }

    public Path getEventLogFilePath(Path appLogDir, String appId, Option<String> appAttemptId, long index, Option<String> codecName) {
        String base = this.EVENT_LOG_FILE_NAME_PREFIX() + index + "_" + EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId);
        String codec = (String)codecName.map((Function1 & Serializable)x$9 -> "." + x$9).getOrElse((Function0 & Serializable)() -> "");
        return new Path(appLogDir, base + codec);
    }

    public boolean isEventLogDir(FileStatus status) {
        return status.isDirectory() && status.getPath().getName().startsWith(this.EVENT_LOG_DIR_NAME_PREFIX());
    }

    public boolean isEventLogFile(String fileName) {
        return fileName.startsWith(this.EVENT_LOG_FILE_NAME_PREFIX());
    }

    public boolean isEventLogFile(FileStatus status) {
        return status.isFile() && this.isEventLogFile(status.getPath().getName());
    }

    public boolean isAppStatusFile(FileStatus status) {
        return status.isFile() && status.getPath().getName().startsWith(this.APPSTATUS_FILE_NAME_PREFIX());
    }

    public long getEventLogFileIndex(String eventLogFileName) {
        Predef$.MODULE$.require(this.isEventLogFile(eventLogFileName), (Function0 & Serializable)() -> "Not an event log file!");
        String index = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(eventLogFileName), this.EVENT_LOG_FILE_NAME_PREFIX()).split("_")[0];
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(index));
    }

    private RollingEventLogFilesWriter$() {
    }
}

