/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.metricview.util;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.metricview.logical.MetricViewPlaceholder;
import org.apache.spark.sql.metricview.logical.MetricViewPlaceholder$;
import org.apache.spark.sql.metricview.serde.AssetSource;
import org.apache.spark.sql.metricview.serde.MetricView;
import org.apache.spark.sql.metricview.serde.MetricViewFactory$;
import org.apache.spark.sql.metricview.serde.MetricViewValidationException;
import org.apache.spark.sql.metricview.serde.MetricViewYAMLParsingException;
import org.apache.spark.sql.metricview.serde.SQLSource;
import org.apache.spark.sql.metricview.serde.Source;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;

public final class MetricViewPlanner$ {
    public static final MetricViewPlanner$ MODULE$ = new MetricViewPlanner$();

    public MetricViewPlaceholder planWrite(CatalogTable metadata, String yaml, ParserInterface sqlParser) {
        Tuple2<MetricView, LogicalPlan> tuple2 = this.parseYAML(yaml, sqlParser);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetricView metricView = (MetricView)tuple2._1();
        LogicalPlan dataModelPlan = (LogicalPlan)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricView, (Object)dataModelPlan);
        MetricView metricView2 = (MetricView)tuple22._1();
        LogicalPlan dataModelPlan2 = (LogicalPlan)tuple22._2();
        return new MetricViewPlaceholder(metadata, metricView2, (Seq<Attribute>)((Seq)package$.MODULE$.Seq().empty()), dataModelPlan2, true);
    }

    public MetricViewPlaceholder planRead(CatalogTable metadata, String yaml, ParserInterface sqlParser, StructType expectedSchema) {
        Tuple2<MetricView, LogicalPlan> tuple2 = this.parseYAML(yaml, sqlParser);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetricView metricView = (MetricView)tuple2._1();
        LogicalPlan dataModelPlan = (LogicalPlan)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metricView, (Object)dataModelPlan);
        MetricView metricView2 = (MetricView)tuple22._1();
        LogicalPlan dataModelPlan2 = (LogicalPlan)tuple22._2();
        return new MetricViewPlaceholder(metadata, metricView2, DataTypeUtils$.MODULE$.toAttributes(expectedSchema), dataModelPlan2, MetricViewPlaceholder$.MODULE$.apply$default$5());
    }

    private Tuple2<MetricView, LogicalPlan> parseYAML(String yaml, ParserInterface sqlParser) {
        LogicalPlan logicalPlan;
        MetricView metricView;
        try {
            metricView = MetricViewFactory$.MODULE$.fromYAML(yaml);
        }
        catch (MetricViewValidationException e) {
            throw QueryCompilationErrors$.MODULE$.invalidLiteralForWindowDurationError();
        }
        catch (MetricViewYAMLParsingException e) {
            throw QueryCompilationErrors$.MODULE$.invalidLiteralForWindowDurationError();
        }
        MetricView metricView2 = metricView;
        Source source = metricView2.from();
        if (source instanceof AssetSource) {
            AssetSource assetSource = (AssetSource)source;
            logicalPlan = new UnresolvedRelation(sqlParser.parseMultipartIdentifier(assetSource.name()), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3());
        } else if (source instanceof SQLSource) {
            SQLSource sQLSource = (SQLSource)source;
            logicalPlan = sqlParser.parsePlan(sQLSource.sql());
        } else {
            throw SparkException$.MODULE$.internalError("Either SQLSource or AssetSource");
        }
        LogicalPlan source2 = logicalPlan;
        LogicalPlan parsedPlan = (LogicalPlan)metricView2.where().map((Function1 & Serializable)cond -> new Filter(sqlParser.parseExpression((String)cond), source2)).getOrElse((Function0 & Serializable)() -> source2);
        return new Tuple2((Object)metricView2, (Object)parsedPlan);
    }

    private MetricViewPlanner$() {
    }
}

