/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNaN$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns true if `expr` is NaN, or false otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double));\n       true\n  ", since="1.5.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\rg\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")!\f\u0001C!7\")q\f\u0001C!7\")\u0001\r\u0001C!C\")1\u000e\u0001C!Y\")!\u0010\u0001C)w\"9a\u0010AA\u0001\n\u0003y\b\"CA\u0002\u0001E\u0005I\u0011AA\u0003\u0011%\tY\u0002AA\u0001\n\u0003\ni\u0002C\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"!\u0015\u0001\u0003\u0003%\t!a\u0015\t\u0013\u0005]\u0003!!A\u0005B\u0005e\u0003\"CA/\u0001\u0005\u0005I\u0011IA0\u000f%\t\u0019iGA\u0001\u0012\u0003\t)I\u0002\u0005\u001b7\u0005\u0005\t\u0012AAD\u0011\u0019YE\u0003\"\u0001\u0002 \"I\u0011\u0011\u0015\u000b\u0002\u0002\u0013\u0015\u00131\u0015\u0005\n\u0003K#\u0012\u0011!CA\u0003OC\u0011\"a+\u0015\u0003\u0003%\t)!,\t\u0013\u0005eF#!A\u0005\n\u0005m&!B%t\u001d\u0006t%B\u0001\u000f\u001e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001IS\u0006M\u001a:!\tQ3&D\u0001\u001c\u0013\ta3DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQc&\u0003\u000207\tI\u0001K]3eS\u000e\fG/\u001a\t\u0003UEJ!AM\u000e\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}\u001d\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005\u0005+\u0014a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!Q\u001b\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u001d\u0003\"A\u000b%\n\u0005%[\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDCA'O!\tQ\u0003\u0001C\u0003F\u0007\u0001\u0007q)\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0015\t\u0004uI#\u0016BA*E\u0005\r\u0019V-\u001d\t\u0003+bk\u0011A\u0016\u0006\u0003/~\tQ\u0001^=qKNL!!\u0017,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017AG2p]R,\u0007\u0010^%oI\u0016\u0004XM\u001c3f]R4u\u000e\u001c3bE2,W#\u0001/\u0011\u0005Qj\u0016B\u000106\u0005\u001d\u0011un\u001c7fC:\f\u0001B\\;mY\u0006\u0014G.Z\u0001\u0005KZ\fG\u000e\u0006\u0002cKB\u0011AgY\u0005\u0003IV\u00121!\u00118z\u0011\u001d1w\u0001%AA\u0002\u001d\fQ!\u001b8qkR\u0004\"\u0001[5\u000e\u0003uI!A[\u000f\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2!\\:y!\tq\u0017/D\u0001p\u0015\t\u00018$A\u0004d_\u0012,w-\u001a8\n\u0005I|'\u0001C#yaJ\u001cu\u000eZ3\t\u000bQD\u0001\u0019A;\u0002\u0007\r$\b\u0010\u0005\u0002om&\u0011qo\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015I\b\u00021\u0001n\u0003\t)g/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u001brDQ!`\u0005A\u0002\u001d\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0002N\u0003\u0003Aq!\u0012\u0006\u0011\u0002\u0003\u0007q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d!fA$\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003mC:<'BAA\u0015\u0003\u0011Q\u0017M^1\n\t\u00055\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0002c\u0001\u001b\u00026%\u0019\u0011qG\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\t\fi\u0004C\u0005\u0002@9\t\t\u00111\u0001\u00024\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0012\u0011\u000b\u0005\u001d\u0013Q\n2\u000e\u0005\u0005%#bAA&k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002]\u0003+B\u0001\"a\u0010\u0011\u0003\u0003\u0005\rAY\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002 \u0005m\u0003\"CA #\u0005\u0005\t\u0019AA\u001a\u0003\u0019)\u0017/^1mgR\u0019A,!\u0019\t\u0011\u0005}\"#!AA\u0002\tD3\u0003AA3\u0003W\ni'!\u001d\u0002t\u0005]\u0014\u0011PA?\u0003\u007f\u00022AKA4\u0013\r\tIg\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty'A!`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0002W\r\u001f9sA\u0002J7\u000f\t(b\u001d2\u0002sN\u001d\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005AQ\r_1na2,7/\t\u0002\u0002v\u0005Y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2bgRDsET1OO\u0001\n7\u000f\t3pk\ndW-K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111P\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0003\u000bq\u0002\u001d:fI&\u001c\u0017\r^3`MVt7m]\u0001\u0006\u0013Nt\u0015M\u0014\t\u0003UQ\u0019R\u0001FAE\u0003+\u0003b!a#\u0002\u0012\u001ekUBAAG\u0015\r\ty)N\u0001\beVtG/[7f\u0013\u0011\t\u0019*!$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*a\n\u0002\u0005%|\u0017bA\"\u0002\u001aR\u0011\u0011QQ\u0001\ti>\u001cFO]5oOR\u0011\u0011qD\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001b\u0006%\u0006\"B#\u0018\u0001\u00049\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\u000b)\f\u0005\u00035\u0003c;\u0015bAAZk\t1q\n\u001d;j_:D\u0001\"a.\u0019\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA_!\u0011\t\t#a0\n\t\u0005\u0005\u00171\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class IsNaN
extends UnaryExpression
implements Predicate,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(IsNaN x$0) {
        return IsNaN$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<IsNaN, A> g) {
        return IsNaN$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, IsNaN> compose(Function1<A$, Expression> g) {
        return IsNaN$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Object eval(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return BoxesRunTime.boxToBoolean((boolean)false);
        }
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Double.isNaN(BoxesRunTime.unboxToDouble((Object)value)));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)Float.isNaN(BoxesRunTime.unboxToFloat((Object)value)));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode eval = this.child().genCode(ctx);
        DataType dataType = this.child().dataType();
        if (DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType)) {
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          ", " ", " = ", ";\n          ", " = !", " && Double.isNaN(", ");"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.value(), eval.isNull(), eval.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public IsNaN withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public IsNaN copy(Expression child) {
        return new IsNaN(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "IsNaN";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IsNaN;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IsNaN)) return false;
        boolean bl = true;
        if (!bl) return false;
        IsNaN isNaN = (IsNaN)x$1;
        Expression expression = this.child();
        Expression expression2 = isNaN.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!isNaN.canEqual(this)) return false;
        return true;
    }

    public IsNaN(Expression child) {
        this.child = child;
        Predicate.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

