/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ChRootedFs
extends AbstractFileSystem {
    private final AbstractFileSystem myFs;
    private final URI myUri;
    private final Path chRootPathPart;
    private final String chRootPathPartString;

    protected AbstractFileSystem getMyFs() {
        return this.myFs;
    }

    protected Path fullPath(Path path) {
        super.checkPath(path);
        return new Path((this.chRootPathPart.isRoot() ? "" : this.chRootPathPartString) + path.toUri().getPath());
    }

    @Override
    public boolean isValidName(String src) {
        return this.myFs.isValidName(this.fullPath(new Path(src)).toUri().toString());
    }

    public ChRootedFs(AbstractFileSystem fs, Path theRoot) throws URISyntaxException {
        super(fs.getUri(), fs.getUri().getScheme(), false, fs.getUriDefaultPort());
        this.myFs = fs;
        this.myFs.checkPath(theRoot);
        this.chRootPathPart = new Path(this.myFs.getUriPath(theRoot));
        this.chRootPathPartString = this.chRootPathPart.toUri().getPath();
        this.myUri = new URI(this.myFs.getUri().toString() + (this.myFs.getUri().getAuthority() == null ? "" : "/") + this.chRootPathPart.toUri().getPath().substring(1));
        super.checkPath(theRoot);
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    public String stripOutRoot(Path p) {
        try {
            this.checkPath(p);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal Error - path " + p + " should have been with URI" + this.myUri);
        }
        String pathPart = p.toUri().getPath();
        return pathPart.length() == this.chRootPathPartString.length() ? "" : pathPart.substring(this.chRootPathPartString.length() + (this.chRootPathPart.isRoot() ? 0 : 1));
    }

    @Override
    public Path getHomeDirectory() {
        return this.myFs.getHomeDirectory();
    }

    @Override
    public Path getInitialWorkingDirectory() {
        return null;
    }

    public Path getResolvedQualifiedPath(Path f) throws FileNotFoundException {
        return this.myFs.makeQualified(new Path(this.chRootPathPartString + f.toUri().toString()));
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException, UnresolvedLinkException {
        return this.myFs.createInternal(this.fullPath(f), flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        return this.myFs.delete(this.fullPath(f), recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileBlockLocations(this.fullPath(f), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileChecksum(this.fullPath(f));
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileStatus(this.fullPath(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.myFs.access(this.fullPath(path), mode);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileLinkStatus(this.fullPath(f));
    }

    @Override
    public FsStatus getFsStatus() throws IOException {
        return this.myFs.getFsStatus();
    }

    @Override
    @Deprecated
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.myFs.getServerDefaults();
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.myFs.getServerDefaults(this.fullPath(f));
    }

    @Override
    public int getUriDefaultPort() {
        return this.myFs.getUriDefaultPort();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.listStatus(this.fullPath(f));
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.listStatusIterator(this.fullPath(f));
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.listLocatedStatus(this.fullPath(f));
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.myFs.mkdir(this.fullPath(dir), permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        return this.myFs.open(this.fullPath(f), bufferSize);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException, UnresolvedLinkException {
        return this.myFs.truncate(this.fullPath(f), newLength);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        this.myFs.renameInternal(this.fullPath(src), this.fullPath(dst));
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        this.myFs.renameInternal(this.fullPath(src), this.fullPath(dst), overwrite);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.myFs.setOwner(this.fullPath(f), username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.myFs.setPermission(this.fullPath(f), permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException, UnresolvedLinkException {
        return this.myFs.setReplication(this.fullPath(f), replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.myFs.setTimes(this.fullPath(f), mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.modifyAclEntries(this.fullPath(path), aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.removeAclEntries(this.fullPath(path), aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        this.myFs.removeDefaultAcl(this.fullPath(path));
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        this.myFs.removeAcl(this.fullPath(path));
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.myFs.setAcl(this.fullPath(path), aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        return this.myFs.getAclStatus(this.fullPath(path));
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.myFs.setXAttr(this.fullPath(path), name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.myFs.getXAttr(this.fullPath(path), name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.myFs.getXAttrs(this.fullPath(path));
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.myFs.getXAttrs(this.fullPath(path), names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        return this.myFs.listXAttrs(this.fullPath(path));
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        this.myFs.removeXAttr(this.fullPath(path), name);
    }

    @Override
    public Path createSnapshot(Path path, String name) throws IOException {
        return this.myFs.createSnapshot(this.fullPath(path), name);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.myFs.renameSnapshot(this.fullPath(path), snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        this.myFs.deleteSnapshot(this.fullPath(snapshotDir), snapshotName);
    }

    @Override
    public void satisfyStoragePolicy(Path path) throws IOException {
        this.myFs.satisfyStoragePolicy(path);
    }

    @Override
    public void setStoragePolicy(Path path, String policyName) throws IOException {
        this.myFs.setStoragePolicy(this.fullPath(path), policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        this.myFs.unsetStoragePolicy(this.fullPath(src));
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        return this.myFs.getStoragePolicy(src);
    }

    @Override
    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        return this.myFs.getAllStoragePolicies();
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.myFs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public boolean supportsSymlinks() {
        return this.myFs.supportsSymlinks();
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.myFs.createSymlink(this.fullPath(target), link, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.myFs.getLinkTarget(this.fullPath(f));
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return this.myFs.getDelegationTokens(renewer);
    }
}

