/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Rows;

class BufferedRows
extends Rows {
    private final LinkedList<Rows.Row> list = new LinkedList();
    private final Iterator<Rows.Row> iterator;
    private int maxColumnWidth;

    BufferedRows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this(beeLine, rs, (Optional<Integer>)Optional.absent());
    }

    BufferedRows(BeeLine beeLine, ResultSet rs, Optional<Integer> limit) throws SQLException {
        super(beeLine, rs);
        int count = this.rsMeta.getColumnCount();
        this.list.add(new Rows.Row(count));
        if (limit.isPresent()) {
            for (int numRowsBuffered = 0; (Integer)limit.get() > numRowsBuffered && rs.next(); ++numRowsBuffered) {
                this.list.add(new Rows.Row(count, rs));
            }
        } else {
            while (rs.next()) {
                this.list.add(new Rows.Row(count, rs));
            }
        }
        this.iterator = this.list.iterator();
        this.maxColumnWidth = beeLine.getOpts().getMaxColumnWidth();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    void normalizeWidths() {
        int[] max = null;
        for (Rows.Row row : this.list) {
            if (max == null) {
                max = new int[row.values.length];
            }
            for (int j = 0; j < max.length; ++j) {
                max[j] = Math.min(Math.max(max[j], row.sizes[j] + 1), this.maxColumnWidth);
            }
        }
        for (Rows.Row row : this.list) {
            row.sizes = max;
        }
    }
}

