/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.UnresolvedOrdinal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.NameScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.OrdinalReplacementExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.OrdinalReplacementGroupingExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.OrdinalReplacementSortOrderExpressions;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Y3A\u0001C\u0005\u00011!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00046\u0001\t\u0007I\u0011\u0002\u001c\t\ri\u0002\u0001\u0015!\u00038\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015y\u0004\u0001\"\u0003A\u0011\u0015Y\u0005\u0001\"\u0003M\u0005=y%\u000fZ5oC2\u0014Vm]8mm\u0016\u0014(B\u0001\u0006\f\u0003!\u0011Xm]8mm\u0016\u0014(B\u0001\u0007\u000e\u0003!\tg.\u00197zg&\u001c(B\u0001\b\u0010\u0003!\u0019\u0017\r^1msN$(B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004B\u0001I\u0011$O5\t\u0011\"\u0003\u0002#\u0013\t\u0001BK]3f\u001d>$WMU3t_24XM\u001d\t\u0003I\u0015j\u0011aC\u0005\u0003M-\u0011\u0011#\u00168sKN|GN^3e\u001fJ$\u0017N\\1m!\tA3&D\u0001*\u0015\tQS\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0017*\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0013Kb\u0004(/Z:tS>t'+Z:pYZ,'\u000f\u0005\u0002!_%\u0011\u0001'\u0003\u0002\u0013\u000bb\u0004(/Z:tS>t'+Z:pYZ,'/\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"\u0001\t\u0001\t\u000b5\u0012\u0001\u0019\u0001\u0018\u0002\rM\u001cw\u000e]3t+\u00059\u0004C\u0001\u00119\u0013\tI\u0014B\u0001\bOC6,7kY8qKN#\u0018mY6\u0002\u000fM\u001cw\u000e]3tA\u00059!/Z:pYZ,GCA\u0014>\u0011\u0015qT\u00011\u0001$\u0003E)hN]3t_24X\rZ(sI&t\u0017\r\\\u0001$e\u0016\u0004H.Y2f\u001fJ$\u0017N\\1m\u0013:<%o\\;qS:<W\t\u001f9sKN\u001c\u0018n\u001c8t)\r9\u0013I\u0012\u0005\u0006\u0005\u001a\u0001\raQ\u0001\b_J$\u0017N\\1m!\tQB)\u0003\u0002F7\t\u0019\u0011J\u001c;\t\u000b\u001d3\u0001\u0019\u0001%\u0002K=\u0014H-\u001b8bYJ+\u0007\u000f\\1dK6,g\u000e^$s_V\u0004\u0018N\\4FqB\u0014Xm]:j_:\u001c\bC\u0001\u0011J\u0013\tQ\u0015BA\u0013Pe\u0012Lg.\u00197SKBd\u0017mY3nK:$xI]8va&tw-\u0012=qe\u0016\u001c8/[8og\u0006!#/\u001a9mC\u000e,wJ\u001d3j]\u0006d\u0017J\\*peR|%\u000fZ3s\u000bb\u0004(/Z:tS>t7\u000fF\u0002N!F\u0003\"\u0001\u000b(\n\u0005=K#!C!uiJL'-\u001e;f\u0011\u0015\u0011u\u00011\u0001D\u0011\u0015\u0011v\u00011\u0001T\u0003\u0019z'\u000fZ5oC2\u0014V\r\u001d7bG\u0016lWM\u001c;T_J$xJ\u001d3fe\u0016C\bO]3tg&|gn\u001d\t\u0003AQK!!V\u0005\u0003M=\u0013H-\u001b8bYJ+\u0007\u000f\\1dK6,g\u000e^*peR|%\u000fZ3s\u000bb\u0004(/Z:tS>t7\u000f")
public class OrdinalResolver
implements TreeNodeResolver<UnresolvedOrdinal, Expression> {
    private final NameScopeStack scopes;

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private NameScopeStack scopes() {
        return this.scopes;
    }

    @Override
    public Expression resolve(UnresolvedOrdinal unresolvedOrdinal) {
        OrdinalReplacementExpressions sortOrderCandidates;
        boolean bl = false;
        Some some = null;
        Option<OrdinalReplacementExpressions> option = this.scopes().current().getOrdinalReplacementExpressions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            OrdinalReplacementExpressions resolvedAggregateExpressions = (OrdinalReplacementExpressions)some.value();
            if (resolvedAggregateExpressions instanceof OrdinalReplacementGroupingExpressions) {
                OrdinalReplacementGroupingExpressions ordinalReplacementGroupingExpressions = (OrdinalReplacementGroupingExpressions)resolvedAggregateExpressions;
                if (this.conf().groupByOrdinal()) {
                    return this.replaceOrdinalInGroupingExpressions(unresolvedOrdinal.ordinal(), ordinalReplacementGroupingExpressions);
                }
            }
        }
        if (bl && (sortOrderCandidates = (OrdinalReplacementExpressions)some.value()) instanceof OrdinalReplacementSortOrderExpressions) {
            OrdinalReplacementSortOrderExpressions ordinalReplacementSortOrderExpressions = (OrdinalReplacementSortOrderExpressions)sortOrderCandidates;
            if (this.conf().orderByOrdinal()) {
                return this.replaceOrdinalInSortOrderExpressions(unresolvedOrdinal.ordinal(), ordinalReplacementSortOrderExpressions);
            }
        }
        throw SparkException$.MODULE$.internalError("Cannot resolve UnresolvedOrdinal in single-pass.");
    }

    private Expression replaceOrdinalInGroupingExpressions(int ordinal, OrdinalReplacementGroupingExpressions ordinalReplacementGroupingExpressions) {
        if (ordinal > ordinalReplacementGroupingExpressions.expressions().length() || ordinal < 1) {
            throw QueryCompilationErrors$.MODULE$.groupByPositionRangeError(ordinal, ordinalReplacementGroupingExpressions.expressions().size());
        }
        if (ordinalReplacementGroupingExpressions.expressionIndexesWithAggregateFunctions().contains(BoxesRunTime.boxToInteger((int)(ordinal - 1)))) {
            throw QueryCompilationErrors$.MODULE$.groupByPositionRefersToAggregateFunctionError(ordinal, (Expression)ordinalReplacementGroupingExpressions.expressions().apply(ordinal - 1));
        }
        if (ordinalReplacementGroupingExpressions.hasStar()) {
            throw QueryCompilationErrors$.MODULE$.starNotAllowedWhenGroupByOrdinalPositionUsedError();
        }
        NamedExpression namedExpression = (NamedExpression)ordinalReplacementGroupingExpressions.expressions().apply(ordinal - 1);
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            return alias.child();
        }
        return (Expression)((Object)namedExpression);
    }

    private Attribute replaceOrdinalInSortOrderExpressions(int ordinal, OrdinalReplacementSortOrderExpressions ordinalReplacementSortOrderExpressions) {
        if (ordinal > ordinalReplacementSortOrderExpressions.expressions().size() || ordinal < 1) {
            throw QueryCompilationErrors$.MODULE$.orderByPositionRangeError(ordinal, ordinalReplacementSortOrderExpressions.expressions().size(), ordinalReplacementSortOrderExpressions.unresolvedSort());
        }
        return ((NamedExpression)ordinalReplacementSortOrderExpressions.expressions().apply(ordinal - 1)).toAttribute();
    }

    public OrdinalResolver(ExpressionResolver expressionResolver) {
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.scopes = expressionResolver.getNameScopes();
    }
}

