/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetRankBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetRankFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(left, right) - Extracts a single value from the quantiles sketch representing the\n    desired rank given the input quantile. The desired rank can either be a single value\n    or an array. In the latter case, the function will return an array of results of equal\n    length to the input array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(kll_sketch_agg_float(col), 3.0) > 0.3 FROM VALUES (CAST(1.0 AS FLOAT)), (CAST(2.0 AS FLOAT)), (CAST(3.0 AS FLOAT)), (CAST(4.0 AS FLOAT)), (CAST(5.0 AS FLOAT)) tab(col);\n       true\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u001dA\b!!A\u0005\u0002eDq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010\u0003\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001~\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003sA\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\t\u0013\u0005M\u0003!!A\u0005B\u0005U\u0003\"CA-\u0001\u0005\u0005I\u0011IA.\u000f%\ty\bHA\u0001\u0012\u0003\t\tI\u0002\u0005\u001c9\u0005\u0005\t\u0012AAB\u0011\u0019AU\u0003\"\u0001\u0002\u001c\"I\u0011QT\u000b\u0002\u0002\u0013\u0015\u0013q\u0014\u0005\n\u0003C+\u0012\u0011!CA\u0003GC\u0011\"!+\u0016\u0003\u0003%\t)a+\t\u0013\u0005uV#!A\u0005\n\u0005}&!F&mYN[W\r^2i\u000f\u0016$(+\u00198l\r2|\u0017\r\u001e\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M!\u0001A\u000b\u00185!\tYC&D\u0001\u001d\u0013\tiCD\u0001\u000bLY2\u001c6.\u001a;dQ\u001e+GOU1oW\n\u000b7/\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\t)TH\u0004\u00027w9\u0011qGO\u0007\u0002q)\u0011\u0011\bK\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!\u0001\u0010\u0019\u0002\u000fA\f7m[1hK&\u0011ah\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003yA\nA\u0001\\3giV\t!\t\u0005\u0002,\u0007&\u0011A\t\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0015.c\u0005CA\u0016\u0001\u0011\u0015\u0001U\u00011\u0001C\u0011\u00151U\u00011\u0001C\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002C\u001fFCQ\u0001\u0015\u0004A\u0002\t\u000bqA\\3x\u0019\u00164G\u000fC\u0003S\r\u0001\u0007!)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002+B\u0011aK\u0017\b\u0003/b\u0003\"a\u000e\u0019\n\u0005e\u0003\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\u0019\u0002\u001b%t\u0007/\u001e;ECR\fG+\u001f9f+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012!\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0017M\u0001\u0005ECR\fG+\u001f9f\u0003AYG\u000e\\*lKR\u001c\u0007nR3u%\u0006t7\u000eF\u0002hUN\u0004\"a\f5\n\u0005%\u0004$A\u0002#pk\ndW\rC\u0003l\u0013\u0001\u0007A.\u0001\u0004nK6|'/\u001f\t\u0003[Fl\u0011A\u001c\u0006\u0003W>T!\u0001\u001d\u0013\u0002\u0019\u0011\fG/Y:lKR\u001c\u0007.Z:\n\u0005It'AB'f[>\u0014\u0018\u0010C\u0003u\u0013\u0001\u0007Q/\u0001\u0005rk\u0006tG/\u001b7f!\tyc/\u0003\u0002xa\t\u0019\u0011I\\=\u0002\t\r|\u0007/\u001f\u000b\u0004\u0015j\\\bb\u0002!\u000b!\u0003\u0005\rA\u0011\u0005\b\r*\u0001\n\u00111\u0001C\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A \u0016\u0003\u0005~\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017\u0001\u0014AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006L1aWA\u000e\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0003E\u00020\u0003WI1!!\f1\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r)\u00181\u0007\u0005\n\u0003ky\u0011\u0011!a\u0001\u0003S\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001e!\u0015\ti$a\u0011v\u001b\t\tyDC\u0002\u0002BA\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)%a\u0010\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u00020\u0003\u001bJ1!a\u00141\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u000e\u0012\u0003\u0003\u0005\r!^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0018\u0005]\u0003\"CA\u001b%\u0005\u0005\t\u0019AA\u0015\u0003\u0019)\u0017/^1mgR!\u00111JA/\u0011!\t)dEA\u0001\u0002\u0004)\bf\u0005\u0001\u0002b\u0005\u001d\u0014\u0011NA7\u0003_\n\u0019(!\u001e\u0002z\u0005m\u0004cA\u0016\u0002d%\u0019\u0011Q\r\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111N\u0001\u0003h)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015mK\u001a$H\u0006\t:jO\"$\u0018\u0006I\u0017!\u000bb$(/Y2ug\u0002\n\u0007e]5oO2,\u0007E^1mk\u0016\u0004cM]8nAQDW\rI9vC:$\u0018\u000e\\3tAM\\W\r^2iAI,\u0007O]3tK:$\u0018N\\4!i\",'\u0002\t\u0011!A\u0011,7/\u001b:fI\u0002\u0012\u0018M\\6!O&4XM\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\nX/\u00198uS2,g\u0006\t+iK\u0002\"Wm]5sK\u0012\u0004#/\u00198lA\r\fg\u000eI3ji\",'\u000f\t2fA\u0005\u00043/\u001b8hY\u0016\u0004c/\u00197vK*\u0001\u0003\u0005\t\u0011pe\u0002\ng\u000eI1se\u0006Lh\u0006I%oAQDW\r\t7biR,'\u000fI2bg\u0016d\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004s/\u001b7mAI,G/\u001e:oA\u0005t\u0007%\u0019:sCf\u0004sN\u001a\u0011sKN,H\u000e^:!_\u001a\u0004S-];bY*\u0001\u0003\u0005\t\u0011mK:<G\u000f\u001b\u0011u_\u0002\"\b.\u001a\u0011j]B,H\u000fI1se\u0006LhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA9\u0003\u0005e&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK6mY~\u001b8.\u001a;dQ~\u000bwmZ0gY>\fG\u000fK2pY&b\u0003e\r\u00181S\u0001r\u0004\u0005\r\u00184A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)\u0007\u0006\u001bF\u000bK\u0019/a\u0001\n5\u000b\t$M\u001f\u0006#\u0016&\u000b\u0017!Q\r\u000b5\u000b\u0016\u00153]A\u0002\u0013i\u0015\u0011G\u0019>\u000bE+K\u0015-A!\u001a\u0015i\u0015+)g9\u0002\u0004%Q*!\r2{\u0015\tV\u0015*Y\u0001B3)Q*UQQr\u0003\u0007I!TA\u0019cu*\u0011+*S1\u0002\u0003fQ!T)\"*d\u0006\r\u0011B'\u00022EjT!US%\u0002C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005]\u0014AC7jg\u000e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011QP\u0001\u0006i9\nd\u0006M\u0001\u0016\u00172d7k[3uG\"<U\r\u001e*b].4En\\1u!\tYScE\u0003\u0016\u0003\u000b\u000b\t\nE\u0004\u0002\b\u00065%I\u0011&\u000e\u0005\u0005%%bAAFa\u00059!/\u001e8uS6,\u0017\u0002BAH\u0003\u0013\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\t\u0019*!'\u000e\u0005\u0005U%\u0002BAL\u0003?\t!![8\n\u0007y\n)\n\u0006\u0002\u0002\u0002\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0018\u0005)\u0011\r\u001d9msR)!*!*\u0002(\")\u0001\t\u0007a\u0001\u0005\")a\t\u0007a\u0001\u0005\u00069QO\\1qa2LH\u0003BAW\u0003s\u0003RaLAX\u0003gK1!!-1\u0005\u0019y\u0005\u000f^5p]B)q&!.C\u0005&\u0019\u0011q\u0017\u0019\u0003\rQ+\b\u000f\\33\u0011!\tY,GA\u0001\u0002\u0004Q\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0019\t\u0005\u00033\t\u0019-\u0003\u0003\u0002F\u0006m!AB(cU\u0016\u001cG\u000f")
public class KllSketchGetRankFloat
extends KllSketchGetRankBase
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(KllSketchGetRankFloat x$0) {
        return KllSketchGetRankFloat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, KllSketchGetRankFloat> tupled() {
        return KllSketchGetRankFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KllSketchGetRankFloat>> curried() {
        return KllSketchGetRankFloat$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_get_rank_float";
    }

    @Override
    public DataType inputDataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public double kllSketchGetRank(Memory memory, Object quantile) {
        return BoxesRunTime.unboxToDouble(this.withRankErrorHandling((JFunction0.mcD.sp & Serializable)() -> KllFloatsSketch.wrap((Memory)memory).getRank(BoxesRunTime.unboxToFloat((Object)quantile))));
    }

    public KllSketchGetRankFloat copy(Expression left, Expression right) {
        return new KllSketchGetRankFloat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "KllSketchGetRankFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchGetRankFloat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchGetRankFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchGetRankFloat kllSketchGetRankFloat = (KllSketchGetRankFloat)x$1;
        Expression expression = this.left();
        Expression expression2 = kllSketchGetRankFloat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = kllSketchGetRankFloat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kllSketchGetRankFloat.canEqual(this)) return false;
        return true;
    }

    public KllSketchGetRankFloat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

