/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.runtime.WatermarkPropagator;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m3AAC\u0006\u00015!)Q\u0005\u0001C\u0001M!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003BB\u001b\u0001A\u0003%!\u0006C\u00037\u0001\u0011%q\u0007C\u0003>\u0001\u0011\u0005c\bC\u0003L\u0001\u0011%A\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003U\u0001\u0011\u0005Q\u000bC\u0003Y\u0001\u0011\u0005\u0013L\u0001\u000fVg\u0016\u001c\u0016N\\4mK^\u000bG/\u001a:nCJ\\\u0007K]8qC\u001e\fGo\u001c:\u000b\u00051i\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u001d=\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005A\t\u0012!C3yK\u000e,H/[8o\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"A\u0006\n\u0005\u0011Z!aE,bi\u0016\u0014X.\u0019:l!J|\u0007/Y4bi>\u0014\u0018A\u0002\u001fj]&$h\bF\u0001(!\t\u0011\u0003!\u0001\ncCR\u001c\u0007.\u00133U_^\u000bG/\u001a:nCJ\\W#\u0001\u0016\u0011\t-\u0002$GM\u0007\u0002Y)\u0011QFL\u0001\u0005kRLGNC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#a\u0002+sK\u0016l\u0015\r\u001d\t\u00039MJ!\u0001N\u000f\u0003\t1{gnZ\u0001\u0014E\u0006$8\r[%e)><\u0016\r^3s[\u0006\u00148\u000eI\u0001\u000eSNLe.\u001b;jC2L'0\u001a3\u0015\u0005aZ\u0004C\u0001\u000f:\u0013\tQTDA\u0004C_>dW-\u00198\t\u000bq\"\u0001\u0019\u0001\u001a\u0002\u000f\t\fGo\u00195JI\u0006I\u0001O]8qC\u001e\fG/\u001a\u000b\u0005\u007f\t\u001b\u0015\n\u0005\u0002\u001d\u0001&\u0011\u0011)\b\u0002\u0005+:LG\u000fC\u0003=\u000b\u0001\u0007!\u0007C\u0003E\u000b\u0001\u0007Q)\u0001\u0003qY\u0006t\u0007C\u0001$H\u001b\u0005y\u0011B\u0001%\u0010\u0005%\u0019\u0006/\u0019:l!2\fg\u000eC\u0003K\u000b\u0001\u0007!'A\bpe&<\u0017N\\,bi\u0016\u0014X.\u0019:l\u0003E9W\r^%oaV$x+\u0019;fe6\f'o\u001b\u000b\u0004e5s\u0005\"\u0002\u001f\u0007\u0001\u0004\u0011\u0004\"B(\u0007\u0001\u0004\u0011\u0014!C:uCR,w\n]%e\u0003y9W\r^%oaV$x+\u0019;fe6\f'o\u001b$pe2\u000bG/Z#wK:$8\u000fF\u00023%NCQ\u0001P\u0004A\u0002IBQaT\u0004A\u0002I\nAdZ3u\u0013:\u0004X\u000f^,bi\u0016\u0014X.\u0019:l\r>\u0014XI^5di&|g\u000eF\u00023-^CQ\u0001\u0010\u0005A\u0002IBQa\u0014\u0005A\u0002I\nQ\u0001];sO\u0016$\"a\u0010.\t\u000bqJ\u0001\u0019\u0001\u001a")
public class UseSingleWatermarkPropagator
implements WatermarkPropagator {
    private final TreeMap<Object, Object> batchIdToWatermark = new TreeMap();

    private TreeMap<Object, Object> batchIdToWatermark() {
        return this.batchIdToWatermark;
    }

    private boolean isInitialized(long batchId) {
        return this.batchIdToWatermark().containsKey(BoxesRunTime.boxToLong((long)batchId));
    }

    @Override
    public void propagate(long batchId, SparkPlan plan, long originWatermark) {
        if (batchId < 0L) {
            return;
        }
        if (this.isInitialized(batchId)) {
            long cached = BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId)));
            Predef$.MODULE$.assert(cached == originWatermark, (Function0 & Serializable)() -> "Watermark has been changed for the same batch ID! Batch ID: " + batchId + ", Value in cache: " + cached + ", value given: " + originWatermark);
            return;
        }
        this.batchIdToWatermark().put(BoxesRunTime.boxToLong((long)batchId), BoxesRunTime.boxToLong((long)originWatermark));
    }

    private long getInputWatermark(long batchId, long stateOpId) {
        if (batchId < 0L) {
            return 0L;
        }
        Predef$.MODULE$.assert(this.isInitialized(batchId), (Function0 & Serializable)() -> "Watermark for batch ID " + batchId + " is not yet set!");
        return BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId)));
    }

    @Override
    public long getInputWatermarkForLateEvents(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId, stateOpId);
    }

    @Override
    public long getInputWatermarkForEviction(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId, stateOpId);
    }

    @Override
    public void purge(long batchId) {
        Iterator<Object> keyIter = this.batchIdToWatermark().keySet().iterator();
        boolean stopIter = false;
        while (keyIter.hasNext() && !stopIter) {
            long currKey = BoxesRunTime.unboxToLong((Object)keyIter.next());
            if (currKey <= batchId) {
                keyIter.remove();
                continue;
            }
            stopIter = true;
        }
    }
}

