/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.io.Text;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.CharsetProvider$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef$;
import scala.runtime.ModuleSerializationProxy;

public final class CreateJacksonParser$
implements Serializable {
    public static final CreateJacksonParser$ MODULE$ = new CreateJacksonParser$();

    public JsonParser string(JsonFactory jsonFactory, String record) {
        return jsonFactory.createParser(record);
    }

    public JsonParser utf8String(JsonFactory jsonFactory, UTF8String record) {
        ByteBuffer bb = record.getByteBuffer();
        Predef$.MODULE$.assert(bb.hasArray());
        ByteArrayInputStream bain = new ByteArrayInputStream(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        return jsonFactory.createParser((Reader)new InputStreamReader((InputStream)bain, StandardCharsets.UTF_8));
    }

    public JsonParser text(JsonFactory jsonFactory, Text record) {
        return jsonFactory.createParser(record.getBytes(), 0, record.getLength());
    }

    private Reader getStreamDecoder(String enc, byte[] in, int length) {
        ByteArrayInputStream bais = new ByteArrayInputStream(in, 0, length);
        ReadableByteChannel byteChannel = Channels.newChannel(bais);
        int decodingBufferSize = Math.min(length, 8192);
        String x$1 = enc;
        String x$2 = "Jackson Parser";
        boolean x$3 = CharsetProvider$.MODULE$.newDecoder$default$2();
        boolean x$4 = CharsetProvider$.MODULE$.newDecoder$default$3();
        CharsetDecoder decoder = CharsetProvider$.MODULE$.newDecoder(x$1, x$3, x$4, "Jackson Parser");
        return Channels.newReader(byteChannel, decoder, decodingBufferSize);
    }

    public JsonParser text(String enc, JsonFactory jsonFactory, Text record) {
        Reader sd = this.getStreamDecoder(enc, record.getBytes(), record.getLength());
        return jsonFactory.createParser(sd);
    }

    public JsonParser inputStream(JsonFactory jsonFactory, InputStream is) {
        return jsonFactory.createParser(is);
    }

    public JsonParser inputStream(String enc, JsonFactory jsonFactory, InputStream is) {
        return jsonFactory.createParser((Reader)new InputStreamReader(is, enc));
    }

    public JsonParser internalRow(JsonFactory jsonFactory, InternalRow row) {
        byte[] ba = row.getBinary(0);
        return jsonFactory.createParser(ba, 0, ba.length);
    }

    public JsonParser internalRow(String enc, JsonFactory jsonFactory, InternalRow row) {
        byte[] binary = row.getBinary(0);
        Reader sd = this.getStreamDecoder(enc, binary, binary.length);
        return jsonFactory.createParser(sd);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CreateJacksonParser$.class);
    }

    private CreateJacksonParser$() {
    }
}

