/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.shuffledb.DBBackend;
import org.apache.spark.network.shuffledb.LevelDB;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.apache.spark.network.util.LevelDBProvider;
import org.apache.spark.network.util.RocksDBProvider;
import org.iq80.leveldb.DB;
import org.rocksdb.RocksDB;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class DBProvider {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(DBProvider.class);

    public static org.apache.spark.network.shuffledb.DB initDB(DBBackend dbBackend, File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        if (dbFile != null) {
            return switch (dbBackend) {
                default -> throw new IncompatibleClassChangeError();
                case DBBackend.LEVELDB -> {
                    DB levelDB = LevelDBProvider.initLevelDB(dbFile, version, mapper);
                    logger.warn("The LEVELDB is deprecated. Please use ROCKSDB instead.");
                    if (levelDB != null) {
                        yield new LevelDB(levelDB);
                    }
                    yield null;
                }
                case DBBackend.ROCKSDB -> {
                    RocksDB rocksDB = RocksDBProvider.initRockDB(dbFile, version, mapper);
                    if (rocksDB != null) {
                        yield new org.apache.spark.network.shuffledb.RocksDB(rocksDB);
                    }
                    yield null;
                }
            };
        }
        return null;
    }

    @VisibleForTesting
    public static org.apache.spark.network.shuffledb.DB initDB(DBBackend dbBackend, File file) throws IOException {
        if (file != null) {
            return switch (dbBackend) {
                default -> throw new IncompatibleClassChangeError();
                case DBBackend.LEVELDB -> {
                    logger.warn("The LEVELDB is deprecated. Please use ROCKSDB instead.");
                    yield new LevelDB(LevelDBProvider.initLevelDB(file));
                }
                case DBBackend.ROCKSDB -> new org.apache.spark.network.shuffledb.RocksDB(RocksDBProvider.initRocksDB(file));
            };
        }
        return null;
    }
}

