/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.StandardException;

class ProtocolKey {
    protected Class<?> factoryInterface;
    protected String identifier;

    protected ProtocolKey(Class<?> clazz, String string) {
        this.factoryInterface = clazz;
        this.identifier = string;
    }

    static ProtocolKey create(String string, String string2) throws StandardException {
        Throwable throwable;
        try {
            return new ProtocolKey(Class.forName(string), string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw Monitor.exceptionStartingModule(throwable);
    }

    protected Class<?> getFactoryInterface() {
        return this.factoryInterface;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        return this.factoryInterface.hashCode() + (this.identifier == null ? 0 : this.identifier.hashCode());
    }

    public boolean equals(Object object) {
        if (object instanceof ProtocolKey) {
            ProtocolKey protocolKey = (ProtocolKey)object;
            if (this.factoryInterface != protocolKey.factoryInterface) {
                return false;
            }
            if (this.identifier == null) {
                if (protocolKey.identifier != null) {
                    return false;
                }
            } else {
                if (protocolKey.identifier == null) {
                    return false;
                }
                if (!this.identifier.equals(protocolKey.identifier)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.factoryInterface.getName() + " (" + this.identifier + ")";
    }
}

