/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.stat.Correlation;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaCorrelationExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaCorrelationExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.sparse((int)4, (int[])new int[]{0, 3}, (double[])new double[]{1.0, -2.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)4.0, (double[])new double[]{5.0, 0.0, 3.0})}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)6.0, (double[])new double[]{7.0, 0.0, 8.0})}), RowFactory.create((Object[])new Object[]{Vectors.sparse((int)4, (int[])new int[]{0, 3}, (double[])new double[]{9.0, 1.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        Row r1 = (Row)Correlation.corr((Dataset)df, (String)"features").head();
        System.out.println("Pearson correlation matrix:\n" + r1.get(0).toString());
        Row r2 = (Row)Correlation.corr((Dataset)df, (String)"features", (String)"spearman").head();
        System.out.println("Spearman correlation matrix:\n" + r2.get(0).toString());
        spark.stop();
    }
}

