/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.exception.ResponseException;
import org.apache.skywalking.library.elasticsearch.response.Index;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public boolean exists(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().index().exists(name)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            if (response.status() == HttpStatus.NOT_FOUND) {
                return false;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to check whether index {} exist", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to check whether index {} exist: {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public Optional<Index> get(String name) {
        TypeReference<Map<String, Index>> type = new TypeReference<Map<String, Index>>(){};
        CompletionStage future = this.version.thenCompose(arg_0 -> this.lambda$get$4(name, (TypeReference)type, arg_0));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get index: {}", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to get index, {}: {}", (Object)name, result);
            }
        });
        return (Optional)((CompletableFuture)future).get();
    }

    public boolean create(String name, Mappings mappings, Map<String, ?> settings) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().index().create(name, mappings, settings)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new ResponseException(response.contentUtf8(), response.status().code());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to create index", exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to create index {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public boolean delete(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().index().delete(name)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((deleted, exception) -> {
            if (exception != null) {
                log.error("Failed to delete index. {}", (Object)name, exception);
                return;
            }
            log.debug("Delete index {} result: {}", (Object)name, deleted);
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    public boolean putMapping(String name, String type, Mappings mapping) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().index().putMapping(name, type, mapping)).aggregate().thenApply(response -> {
            if (response.status() == HttpStatus.OK) {
                return true;
            }
            throw new RuntimeException(response.contentUtf8());
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to update index mapping {}, mapping: {}", new Object[]{name, mapping, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded to update index mapping {}, {}", (Object)name, result);
            }
        });
        return (Boolean)((CompletableFuture)future).get();
    }

    @Generated
    public IndexClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }

    private /* synthetic */ CompletionStage lambda$get$4(String name, TypeReference type, ElasticSearchVersion v) {
        return this.client.execute(v.requestFactory().index().get(name)).aggregate().thenApply(response -> {
            HttpStatus status = response.status();
            if (status == HttpStatus.NOT_FOUND) {
                return Optional.empty();
            }
            try (HttpData content = response.content();){
                Optional<Index> optional;
                block15: {
                    InputStream is = content.toInputStream();
                    try {
                        Map indices = (Map)v.codec().decode(is, type);
                        optional = Optional.ofNullable((Index)indices.get(name));
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return optional;
            }
            catch (Exception e) {
                return (Optional)Exceptions.throwUnsafely((Throwable)e);
            }
        });
    }
}

