/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.outlier;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.outlier.DisabledOutlierDetection;
import com.linecorp.armeria.common.outlier.OutlierDetectionBuilder;
import com.linecorp.armeria.common.outlier.OutlierDetector;
import com.linecorp.armeria.common.outlier.OutlierRule;
import java.util.Objects;

@UnstableApi
public interface OutlierDetection {
    public static OutlierDetection of(OutlierRule rule) {
        Objects.requireNonNull(rule, "rule");
        if (rule == OutlierRule.of()) {
            return OutlierDetection.of();
        }
        return OutlierDetection.builder(rule).build();
    }

    public static OutlierDetection of() {
        return OutlierDetectionBuilder.DEFAULT_DETECTION;
    }

    public static OutlierDetectionBuilder builder(OutlierRule rule) {
        Objects.requireNonNull(rule, "rule");
        return new OutlierDetectionBuilder(rule);
    }

    public static OutlierDetection disabled() {
        return DisabledOutlierDetection.INSTANCE;
    }

    public OutlierRule rule();

    public OutlierDetector newDetector();
}

