/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.trace;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.trace.v1.BanyandbTrace;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TraceQuery;
import org.apache.skywalking.banyandb.v1.client.TraceQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryV2DAO;
import org.apache.skywalking.oap.server.core.storage.query.proto.SpanWrapper;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public class BanyanDBZipkinQueryDAO
extends AbstractBanyanDBDAO
implements IZipkinQueryV2DAO {
    private static final int QUERY_MAX_SIZE = Integer.MAX_VALUE;
    private static final Set<String> SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"service_name");
    private static final Set<String> REMOTE_SERVICE_TRAFFIC_TAGS = ImmutableSet.of((Object)"remote_service_name");
    private static final Set<String> SPAN_TRAFFIC_TAGS = ImmutableSet.of((Object)"span_name");

    public BanyanDBZipkinQueryDAO(BanyanDBStorageClient client) {
        super(client);
    }

    public List<String> getServiceNames() throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata("zipkin_service_traffic", DownSampling.Minute);
        MeasureQueryResponse resp = this.query(false, schema, SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> services = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            services.add((String)dataPoint.getTagValue("service_name"));
        }
        return services;
    }

    public List<String> getRemoteServiceNames(final String serviceName) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata("zipkin_service_relation_traffic", DownSampling.Minute);
        MeasureQueryResponse resp = this.query(false, schema, REMOTE_SERVICE_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceName)) {
                    query.and(this.eq("service_name", serviceName));
                }
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> remoteServices = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            remoteServices.add((String)dataPoint.getTagValue("remote_service_name"));
        }
        return remoteServices;
    }

    public List<String> getSpanNames(final String serviceName) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetricMetadata("zipkin_service_span_traffic", DownSampling.Minute);
        MeasureQueryResponse resp = this.query(false, schema, SPAN_TRAFFIC_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                if (StringUtil.isNotEmpty((String)serviceName)) {
                    query.and(this.eq("service_name", serviceName));
                }
                query.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            }
        });
        ArrayList<String> spanNames = new ArrayList<String>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            spanNames.add((String)dataPoint.getTagValue("span_name"));
        }
        return spanNames;
    }

    public List<Span> getTrace(String traceId, @Nullable Duration duration) throws IOException {
        throw new UnsupportedOperationException("BanyanDB Trace Model changed, please use getTraceV2.");
    }

    public List<List<Span>> getTraces(QueryRequest request, Duration duration) throws IOException {
        throw new UnsupportedOperationException("BanyanDB Trace Model changed, please use getTracesV2.");
    }

    public List<List<Span>> getTraces(Set<String> traceIds, @Nullable Duration duration) throws IOException {
        throw new UnsupportedOperationException("BanyanDB Trace Model changed, please use getTracesV2.");
    }

    public List<SpanWrapper> getTraceV2(final String traceId, @Nullable Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        AbstractBanyanDBDAO.QueryBuilder<TraceQuery> query = new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            protected void apply(TraceQuery query) {
                query.and(this.eq("trace_id", traceId));
                query.setLimit(Integer.MAX_VALUE);
            }
        };
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "zipkin_span", this.getTimestampRange(duration), query);
        if (resp.getTraces().isEmpty()) {
            return new ArrayList<SpanWrapper>();
        }
        if (resp.getTraces().size() > 1) {
            throw new IOException("More than one trace returned for traceId: " + traceId);
        }
        ArrayList<SpanWrapper> trace = new ArrayList<SpanWrapper>();
        for (BanyandbTrace.Span span : ((BanyandbTrace.Trace)resp.getTraces().get(0)).getSpansList()) {
            trace.add(SpanWrapper.parseFrom((ByteString)span.getSpan()));
        }
        return trace;
    }

    public List<List<SpanWrapper>> getTracesV2(final Set<String> traceIds, Duration duration) throws IOException {
        if (CollectionUtils.isEmpty(traceIds)) {
            return Collections.emptyList();
        }
        boolean isColdStage = duration != null && duration.isColdStage();
        AbstractBanyanDBDAO.QueryBuilder<TraceQuery> query = new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            protected void apply(TraceQuery query) {
                query.and(this.in("trace_id", new ArrayList<String>(traceIds)));
                query.setOrderBy(new AbstractQuery.OrderBy("timestamp_millis", AbstractQuery.Sort.DESC));
                query.setLimit(Integer.MAX_VALUE);
            }
        };
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "zipkin_span", this.getTimestampRange(duration), query);
        ArrayList<List<SpanWrapper>> traces = new ArrayList<List<SpanWrapper>>();
        for (BanyandbTrace.Trace t : resp.getTraces()) {
            ArrayList<SpanWrapper> trace = new ArrayList<SpanWrapper>();
            for (BanyandbTrace.Span span : t.getSpansList()) {
                trace.add(SpanWrapper.parseFrom((ByteString)span.getSpan()));
            }
            traces.add(trace);
        }
        return traces;
    }

    public List<List<SpanWrapper>> getTracesV2(final QueryRequest request, Duration duration) throws IOException {
        boolean isColdStage = duration != null && duration.isColdStage();
        AbstractBanyanDBDAO.QueryBuilder<TraceQuery> queryBuilder = new AbstractBanyanDBDAO.QueryBuilder<TraceQuery>(){

            @Override
            public void apply(TraceQuery query) {
                if (!StringUtil.isEmpty((String)request.serviceName())) {
                    query.and(this.eq("local_endpoint_service_name", request.serviceName()));
                }
                if (!StringUtil.isEmpty((String)request.remoteServiceName())) {
                    query.and(this.eq("remote_endpoint_service_name", request.remoteServiceName()));
                }
                if (!StringUtil.isEmpty((String)request.spanName())) {
                    query.and(this.eq("name", request.spanName()));
                }
                if (!CollectionUtils.isEmpty((Map)request.annotationQuery())) {
                    ArrayList<String> queryConditions = new ArrayList<String>();
                    for (Map.Entry annotation : request.annotationQuery().entrySet()) {
                        if (((String)annotation.getValue()).isEmpty()) {
                            queryConditions.add((String)annotation.getKey());
                            continue;
                        }
                        queryConditions.add((String)annotation.getKey() + "=" + (String)annotation.getValue());
                    }
                    query.and(this.having("query", queryConditions));
                }
                if (request.minDuration() != null) {
                    query.and(this.gte("duration", request.minDuration()));
                }
                if (request.maxDuration() != null) {
                    query.and(this.lte("duration", request.maxDuration()));
                }
                query.setOrderBy(new AbstractQuery.OrderBy("timestamp_millis", AbstractQuery.Sort.DESC));
                query.setLimit(request.limit());
            }
        };
        TraceQueryResponse resp = this.queryTraceDebuggable(isColdStage, "zipkin_span", this.getTimestampRange(duration), queryBuilder);
        ArrayList<List<SpanWrapper>> traces = new ArrayList<List<SpanWrapper>>();
        for (BanyandbTrace.Trace t : resp.getTraces()) {
            ArrayList<SpanWrapper> trace = new ArrayList<SpanWrapper>();
            for (BanyandbTrace.Span span : t.getSpansList()) {
                trace.add(SpanWrapper.parseFrom((ByteString)span.getSpan()));
            }
            traces.add(trace);
        }
        return traces;
    }
}

