/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import javafx.scene.control.TreeItem;
import org.apache.sis.gui.dataset.ResourceItem;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.Resource;
import org.opengis.metadata.Metadata;

final class RootResource
implements Aggregate {
    private final List<TreeItem<Resource>> components;

    RootResource(TreeItem<Resource> group, TreeItem<Resource> previous) {
        this.components = group.getChildren();
        if (previous != null) {
            this.components.add(previous);
        }
    }

    TreeItem<Resource> contains(Resource resource, boolean remove) {
        int i = this.components.size();
        while (--i >= 0) {
            TreeItem<Resource> item = this.components.get(i);
            if (!((ResourceItem)item).contains(resource)) continue;
            return remove ? this.components.remove(i) : item;
        }
        return null;
    }

    boolean add(Resource resource) {
        int i = this.components.size();
        while (--i >= 0) {
            if (!((ResourceItem)this.components.get(i)).contains(resource)) continue;
            return false;
        }
        return this.components.add(new ResourceItem(resource));
    }

    public Collection<Resource> components() {
        return new AbstractList<Resource>(){

            @Override
            public int size() {
                return RootResource.this.components.size();
            }

            @Override
            public Resource get(int index) {
                return (Resource)RootResource.this.components.get(index).getValue();
            }
        };
    }

    public Metadata getMetadata() {
        return null;
    }
}

