/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class ForkingClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private final ExecutorService executor;

    public ForkingClusterInvoker(Directory<T> directory) {
        super(directory);
        this.executor = directory.getUrl().getOrDefaultFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getSharedExecutor();
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        try {
            List<Invoker<Invoker>> selected;
            int forks = this.getUrl().getParameter("forks", 2);
            int timeout = this.getUrl().getParameter("timeout", 1000);
            if (forks <= 0 || forks >= invokers.size()) {
                selected = invokers;
            } else {
                selected = new ArrayList<Invoker<T>>(forks);
                while (selected.size() < forks) {
                    Invoker<T> invoker2 = this.select(loadbalance, invocation, invokers, selected);
                    if (selected.contains(invoker2)) continue;
                    selected.add(invoker2);
                }
            }
            RpcContext.getServiceContext().setInvokers((List)selected);
            AtomicInteger count = new AtomicInteger();
            LinkedBlockingQueue ref = new LinkedBlockingQueue(1);
            selected.forEach(invoker -> {
                URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
                CompletableFuture.supplyAsync(() -> {
                    if (ref.size() > 0) {
                        return null;
                    }
                    return this.invokeWithContextAsync(invoker, invocation, consumerUrl);
                }, this.executor).whenComplete((v, t) -> {
                    if (t == null) {
                        ref.offer(v);
                    } else {
                        int value = count.incrementAndGet();
                        if (value >= selected.size()) {
                            ref.offer(t);
                        }
                    }
                });
            });
            try {
                Object ret = ref.poll(timeout, TimeUnit.MILLISECONDS);
                if (ret instanceof Throwable) {
                    Throwable e = ret instanceof CompletionException ? ((CompletionException)ret).getCause() : (Throwable)ret;
                    throw new RpcException(e instanceof RpcException ? ((RpcException)e).getCode() : 0, "Failed to forking invoke provider " + selected + ", but no luck to perform the invocation. Last error is: " + e.getMessage(), e.getCause() != null ? e.getCause() : e);
                }
                Result result = (Result)ret;
                return result;
            }
            catch (InterruptedException e) {
                throw new RpcException("Failed to forking invoke provider " + selected + ", but no luck to perform the invocation. Last error is: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            RpcContext.getClientAttachment().clearAttachments();
        }
    }
}

