/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

@Activate(order=100)
public class ProtocolFilterWrapper
implements Protocol {
    private final Protocol protocol;

    public ProtocolFilterWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if (UrlUtils.isRegistry(invoker.getUrl())) {
            return this.protocol.export(invoker);
        }
        FilterChainBuilder builder = this.getFilterChainBuilder(invoker.getUrl());
        return this.protocol.export(builder.buildInvokerChain(invoker, "service.filter", "provider"));
    }

    private <T> FilterChainBuilder getFilterChainBuilder(URL url) {
        return ScopeModelUtil.getExtensionLoader(FilterChainBuilder.class, url.getScopeModel()).getDefaultExtension();
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if (UrlUtils.isRegistry(url)) {
            return this.protocol.refer(type, url);
        }
        FilterChainBuilder builder = this.getFilterChainBuilder(url);
        return builder.buildInvokerChain(this.protocol.refer(type, url), "reference.filter", "consumer");
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    @Override
    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

