/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor.threadpool;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.executor.threadpool.ElasticJobExecutorService;
import org.apache.shardingsphere.elasticjob.kernel.executor.threadpool.JobExecutorThreadPoolSizeProvider;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class ExecutorServiceReloader
implements Closeable {
    private String jobExecutorThreadPoolSizeProviderType;
    private ExecutorService executorService;

    public ExecutorServiceReloader(JobConfiguration jobConfig) {
        this.init(jobConfig);
    }

    public synchronized void reloadIfNecessary(JobConfiguration jobConfig) {
        if (this.jobExecutorThreadPoolSizeProviderType.equals(jobConfig.getJobExecutorThreadPoolSizeProviderType())) {
            return;
        }
        this.executorService.shutdownNow();
        this.init(jobConfig);
    }

    private void init(JobConfiguration jobConfig) {
        JobExecutorThreadPoolSizeProvider jobExecutorThreadPoolSizeProvider = (JobExecutorThreadPoolSizeProvider)TypedSPILoader.getService(JobExecutorThreadPoolSizeProvider.class, (Object)jobConfig.getJobExecutorThreadPoolSizeProviderType());
        this.jobExecutorThreadPoolSizeProviderType = jobExecutorThreadPoolSizeProvider.getType();
        this.executorService = new ElasticJobExecutorService("elasticjob-" + jobConfig.getJobName(), jobExecutorThreadPoolSizeProvider.getSize()).createExecutorService();
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

