/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2Shape;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.spider.Generator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class PolygonGeography
extends Geography {
    private static final Logger logger = Logger.getLogger(PolygonGeography.class.getName());
    public final S2Polygon polygon;

    public PolygonGeography() {
        super(Geography.GeographyKind.POLYGON);
        this.polygon = new S2Polygon();
    }

    public PolygonGeography(S2Polygon polygon) {
        super(Geography.GeographyKind.POLYGON);
        this.polygon = polygon;
    }

    @Override
    public int dimension() {
        return 2;
    }

    @Override
    public int numShapes() {
        return this.polygon.isEmpty() ? 0 : 1;
    }

    @Override
    public S2Shape shape(int id) {
        assert (this.polygon != null);
        return this.polygon.shape();
    }

    @Override
    public S2Region region() {
        return this.polygon;
    }

    @Override
    public void getCellUnionBound(List<S2CellId> cellIds) {
        super.getCellUnionBound(cellIds);
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        this.polygon.encode((OutputStream)out);
        out.flush();
    }

    public static PolygonGeography decode(Input in, EncodeTag tag) throws IOException {
        if (!(in instanceof UnsafeInput)) {
            throw new IllegalArgumentException("Expected UnsafeInput");
        }
        return PolygonGeography.decode((UnsafeInput)in, tag);
    }

    public static PolygonGeography decode(UnsafeInput in, EncodeTag tag) throws IOException {
        PolygonGeography geo = new PolygonGeography();
        if ((tag.getFlags() & 1) != 0) {
            logger.fine("Decoded empty PolygonGeography.");
            return geo;
        }
        tag.skipCovering(in);
        S2Polygon poly = S2Polygon.decode((InputStream)in);
        geo = new PolygonGeography(poly);
        return geo;
    }

    public CoordinateSequence getCoordinateSequence() {
        int total = 0;
        for (int li = 0; li < this.polygon.numLoops(); ++li) {
            S2Loop loop = this.polygon.loop(li);
            total += loop.numVertices();
        }
        Coordinate[] coords = new Coordinate[total];
        int idx = 0;
        for (int li = 0; li < this.polygon.numLoops(); ++li) {
            S2Loop loop = this.polygon.loop(li);
            int nv = loop.numVertices();
            int vi = 0;
            while (vi < nv) {
                S2Point p = loop.vertex(vi);
                coords[idx] = new Coordinate(p.getX(), p.getY(), p.getZ());
                ++vi;
                ++idx;
            }
        }
        return new CoordinateArraySequence(coords);
    }

    public LinearRing getExteriorRing() {
        if (this.polygon.numLoops() == 0) {
            return Generator.GEOMETRY_FACTORY.createLinearRing(new Coordinate[0]);
        }
        S2Loop loop = this.polygon.loop(0);
        Coordinate[] coords = new Coordinate[loop.numVertices() + 1];
        for (int i = 0; i < loop.numVertices(); ++i) {
            Coordinate c;
            S2Point pt = loop.vertex(i);
            S2LatLng ll = new S2LatLng(pt);
            double lat = ll.latDegrees();
            double lon = ll.lngDegrees();
            coords[i] = c = new Coordinate(lon, lat);
        }
        coords[coords.length - 1] = coords[0];
        return Generator.GEOMETRY_FACTORY.createLinearRing(coords);
    }

    public List<LinearRing> getLoops() {
        ArrayList<LinearRing> loops = new ArrayList<LinearRing>();
        for (int li = 1; li < this.polygon.numLoops(); ++li) {
            S2Loop loop = this.polygon.loop(li);
            Coordinate[] coords = new Coordinate[loop.numVertices() + 1];
            for (int idx = 0; idx < loop.numVertices(); ++idx) {
                Coordinate c;
                S2Point pt = loop.vertex(idx);
                S2LatLng ll = new S2LatLng(pt);
                double lat = ll.latDegrees();
                double lon = ll.lngDegrees();
                coords[idx] = c = new Coordinate(lon, lat);
            }
            coords[coords.length - 1] = coords[0];
            loops.add(Generator.GEOMETRY_FACTORY.createLinearRing(coords));
        }
        return loops;
    }
}

